@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ga.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getAcceleratorSpareIpAttachments.
 * @property acceleratorId
 * @property attachments
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property outputFile
 * @property status
 */
public data class GetAcceleratorSpareIpAttachmentsResult(
    public val acceleratorId: String,
    public val attachments: List<GetAcceleratorSpareIpAttachmentsAttachment>,
    public val id: String,
    public val ids: List<String>,
    public val outputFile: String? = null,
    public val status: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ga.outputs.GetAcceleratorSpareIpAttachmentsResult): GetAcceleratorSpareIpAttachmentsResult = GetAcceleratorSpareIpAttachmentsResult(
            acceleratorId = javaType.acceleratorId(),
            attachments = javaType.attachments().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.ga.kotlin.outputs.GetAcceleratorSpareIpAttachmentsAttachment.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
        )
    }
}
