@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ga.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property acceleratorId The ID of the GA instance to query.
 * @property acceleratorName The Name of the GA instance.
 * @property basicBandwidthPackages Details of the basic bandwidth package bound to the global acceleration instance.
 * @property cenId The cloud enterprise network instance ID bound to the global acceleration instance.
 * @property crossDomainBandwidthPackages Details of the cross-domain acceleration package bound to the global acceleration instance.
 * @property ddosId DDoS high-defense instance ID that is unbound from the global acceleration instance.
 * @property description Descriptive information of the global acceleration instance.
 * @property dnsName CNAME address assigned by Global Acceleration instance.
 * @property expiredTime Time when the global acceleration instance expires.
 * @property id The ID of the Accelerator.
 * @property paymentType The billing method of the GA instance. Valid values: `POSTPAY`, `PREPAY`.
 * @property secondDnsName CNAME of the Global Acceleration Linkage DDoS High Defense Instance.
 * @property spec The instance type of the GA instance.
 * @property status The status of the GA instance. Valid values: `active`, `binding`, `configuring`, `deleting`, `finacialLocked`, `init`, `unbinding`.
 */
public data class GetAcceleratorsAccelerator(
    public val acceleratorId: String,
    public val acceleratorName: String,
    public val basicBandwidthPackages: List<GetAcceleratorsAcceleratorBasicBandwidthPackage>,
    public val cenId: String,
    public val crossDomainBandwidthPackages: List<GetAcceleratorsAcceleratorCrossDomainBandwidthPackage>,
    public val ddosId: String,
    public val description: String,
    public val dnsName: String,
    public val expiredTime: Int,
    public val id: String,
    public val paymentType: String,
    public val secondDnsName: String,
    public val spec: String,
    public val status: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ga.outputs.GetAcceleratorsAccelerator): GetAcceleratorsAccelerator = GetAcceleratorsAccelerator(
            acceleratorId = javaType.acceleratorId(),
            acceleratorName = javaType.acceleratorName(),
            basicBandwidthPackages = javaType.basicBandwidthPackages().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.ga.kotlin.outputs.GetAcceleratorsAcceleratorBasicBandwidthPackage.Companion.toKotlin(args0)
                })
            }),
            cenId = javaType.cenId(),
            crossDomainBandwidthPackages = javaType.crossDomainBandwidthPackages().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.ga.kotlin.outputs.GetAcceleratorsAcceleratorCrossDomainBandwidthPackage.Companion.toKotlin(args0)
                })
            }),
            ddosId = javaType.ddosId(),
            description = javaType.description(),
            dnsName = javaType.dnsName(),
            expiredTime = javaType.expiredTime(),
            id = javaType.id(),
            paymentType = javaType.paymentType(),
            secondDnsName = javaType.secondDnsName(),
            spec = javaType.spec(),
            status = javaType.status(),
        )
    }
}
