@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ga.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property bandwidth Bandwidth value of cross-domain acceleration package.
 * @property bandwidthType The bandwidth type of the basic bandwidth package.
 * @property instanceId Instance ID of the cross-domain acceleration package.
 */
public data class GetAcceleratorsAcceleratorBasicBandwidthPackage(
    public val bandwidth: Int,
    public val bandwidthType: String,
    public val instanceId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ga.outputs.GetAcceleratorsAcceleratorBasicBandwidthPackage): GetAcceleratorsAcceleratorBasicBandwidthPackage =
            GetAcceleratorsAcceleratorBasicBandwidthPackage(
                bandwidth = javaType.bandwidth(),
                bandwidthType = javaType.bandwidthType(),
                instanceId = javaType.instanceId(),
            )
    }
}
