@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ga.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getAccelerators.
 * @property accelerators A list of Ga Accelerators. Each element contains the following attributes:
 * @property bandwidthBillingType
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property nameRegex
 * @property names A list of Accelerator names.
 * @property outputFile
 * @property status The status of the GA instance.
 */
public data class GetAcceleratorsResult(
    public val accelerators: List<GetAcceleratorsAccelerator>,
    public val bandwidthBillingType: String? = null,
    public val id: String,
    public val ids: List<String>,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
    public val status: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ga.outputs.GetAcceleratorsResult): GetAcceleratorsResult = GetAcceleratorsResult(
            accelerators = javaType.accelerators().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.ga.kotlin.outputs.GetAcceleratorsAccelerator.Companion.toKotlin(args0)
                })
            }),
            bandwidthBillingType = javaType.bandwidthBillingType().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
        )
    }
}
