@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ga.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property aclEntries The entries of the Acl.
 * @property aclId The  ID of the Acl.
 * @property aclName The name of the acl.
 * @property addressIpVersion The address ip version.
 * @property id The ID of the Acl. Its value is same as `acl_id`.
 * @property status The status of the resource.
 */
public data class GetAclsAcl(
    public val aclEntries: List<GetAclsAclAclEntry>,
    public val aclId: String,
    public val aclName: String,
    public val addressIpVersion: String,
    public val id: String,
    public val status: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ga.outputs.GetAclsAcl): GetAclsAcl =
            GetAclsAcl(
                aclEntries = javaType.aclEntries().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.alicloud.ga.kotlin.outputs.GetAclsAclAclEntry.Companion.toKotlin(args0)
                    })
                }),
                aclId = javaType.aclId(),
                aclName = javaType.aclName(),
                addressIpVersion = javaType.addressIpVersion(),
                id = javaType.id(),
                status = javaType.status(),
            )
    }
}
