@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ga.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getAcls.
 * @property aclName
 * @property acls
 * @property enableDetails
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property nameRegex
 * @property names
 * @property outputFile
 * @property status
 */
public data class GetAclsResult(
    public val aclName: String? = null,
    public val acls: List<GetAclsAcl>,
    public val enableDetails: Boolean? = null,
    public val id: String,
    public val ids: List<String>,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
    public val status: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ga.outputs.GetAclsResult): GetAclsResult =
            GetAclsResult(
                aclName = javaType.aclName().map({ args0 -> args0 }).orElse(null),
                acls = javaType.acls().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.alicloud.ga.kotlin.outputs.GetAclsAcl.Companion.toKotlin(args0)
                    })
                }),
                enableDetails = javaType.enableDetails().map({ args0 -> args0 }).orElse(null),
                id = javaType.id(),
                ids = javaType.ids().map({ args0 -> args0 }),
                nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
                names = javaType.names().map({ args0 -> args0 }),
                outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
                status = javaType.status().map({ args0 -> args0 }).orElse(null),
            )
    }
}
