@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ga.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property acceleratorId The ID of the GA instance.
 * @property certificateId The Certificate ID.
 * @property domain The domain name specified by the certificate.
 * @property id The ID of the Additional Certificate. The value formats as `<accelerator_id>:<listener_id>:<domain>`.
 * @property listenerId The ID of the listener. Only HTTPS listeners support this parameter.
 */
public data class GetAdditionalCertificatesCertificate(
    public val acceleratorId: String,
    public val certificateId: String,
    public val domain: String,
    public val id: String,
    public val listenerId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ga.outputs.GetAdditionalCertificatesCertificate): GetAdditionalCertificatesCertificate = GetAdditionalCertificatesCertificate(
            acceleratorId = javaType.acceleratorId(),
            certificateId = javaType.certificateId(),
            domain = javaType.domain(),
            id = javaType.id(),
            listenerId = javaType.listenerId(),
        )
    }
}
