@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ga.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getAdditionalCertificates.
 * @property acceleratorId
 * @property certificates
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property listenerId
 * @property outputFile
 */
public data class GetAdditionalCertificatesResult(
    public val acceleratorId: String,
    public val certificates: List<GetAdditionalCertificatesCertificate>,
    public val id: String,
    public val ids: List<String>,
    public val listenerId: String,
    public val outputFile: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ga.outputs.GetAdditionalCertificatesResult): GetAdditionalCertificatesResult = GetAdditionalCertificatesResult(
            acceleratorId = javaType.acceleratorId(),
            certificates = javaType.certificates().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.ga.kotlin.outputs.GetAdditionalCertificatesCertificate.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            listenerId = javaType.listenerId(),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
        )
    }
}
