@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ga.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property bandwidth The bandwidth value of bandwidth packet.
 * @property bandwidthPackageId The Resource ID of the bandwidth.
 * @property bandwidthPackageName The name of the bandwidth packet.
 * @property bandwidthType The bandwidth type of the bandwidth.
 * @property cbnGeographicRegionIda Interworking area A of cross domain acceleration package. Only international stations support returning this parameter.
 * @property cbnGeographicRegionIdb Interworking area B of cross domain acceleration package. Only international stations support returning this parameter.
 * @property description The description of bandwidth package.
 * @property expiredTime Bandwidth package expiration time.
 * @property id The ID of the Bandwidth Package.
 * @property paymentType The payment type of the bandwidth.
 * @property status The status of the bandwidth plan.
 * @property type The type of the bandwidth packet. China station only supports return to basic.
 */
public data class GetBandwidthPackagesPackage(
    public val bandwidth: Int,
    public val bandwidthPackageId: String,
    public val bandwidthPackageName: String,
    public val bandwidthType: String,
    public val cbnGeographicRegionIda: String,
    public val cbnGeographicRegionIdb: String,
    public val description: String,
    public val expiredTime: String,
    public val id: String,
    public val paymentType: String,
    public val status: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ga.outputs.GetBandwidthPackagesPackage): GetBandwidthPackagesPackage = GetBandwidthPackagesPackage(
            bandwidth = javaType.bandwidth(),
            bandwidthPackageId = javaType.bandwidthPackageId(),
            bandwidthPackageName = javaType.bandwidthPackageName(),
            bandwidthType = javaType.bandwidthType(),
            cbnGeographicRegionIda = javaType.cbnGeographicRegionIda(),
            cbnGeographicRegionIdb = javaType.cbnGeographicRegionIdb(),
            description = javaType.description(),
            expiredTime = javaType.expiredTime(),
            id = javaType.id(),
            paymentType = javaType.paymentType(),
            status = javaType.status(),
            type = javaType.type(),
        )
    }
}
