@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ga.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property accelerateIpId The ID of the Basic Accelerate IP.
 * @property acceleratorId The ID of the Global Accelerator Basic Accelerator instance.
 * @property basicEndpointName The name of the Basic Endpoint.
 * @property endpointAddress The address of the Basic Endpoint.
 * @property endpointId The ID of the Basic Endpoint.
 * @property endpointSubAddress The sub address of the Basic Endpoint.
 * @property endpointSubAddressType The sub address type of the Basic Endpoint.
 * @property endpointType The type of the Basic Endpoint.
 * @property endpointZoneId The zone id of the Basic Endpoint.
 * @property id The id of the Global Accelerator Basic Accelerate Ip Endpoint Relation. It formats as `<accelerator_id>:<accelerate_ip_id>:<endpoint_id>`.
 * @property ipAddress The address of the Basic Accelerate IP.
 * @property status The status of the Global Accelerator Basic Accelerate Ip Endpoint Relation. Valid Value: `active`.
 */
public data class GetBasicAccelerateIpEndpointRelationsRelation(
    public val accelerateIpId: String,
    public val acceleratorId: String,
    public val basicEndpointName: String,
    public val endpointAddress: String,
    public val endpointId: String,
    public val endpointSubAddress: String,
    public val endpointSubAddressType: String,
    public val endpointType: String,
    public val endpointZoneId: String,
    public val id: String,
    public val ipAddress: String,
    public val status: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ga.outputs.GetBasicAccelerateIpEndpointRelationsRelation): GetBasicAccelerateIpEndpointRelationsRelation =
            GetBasicAccelerateIpEndpointRelationsRelation(
                accelerateIpId = javaType.accelerateIpId(),
                acceleratorId = javaType.acceleratorId(),
                basicEndpointName = javaType.basicEndpointName(),
                endpointAddress = javaType.endpointAddress(),
                endpointId = javaType.endpointId(),
                endpointSubAddress = javaType.endpointSubAddress(),
                endpointSubAddressType = javaType.endpointSubAddressType(),
                endpointType = javaType.endpointType(),
                endpointZoneId = javaType.endpointZoneId(),
                id = javaType.id(),
                ipAddress = javaType.ipAddress(),
                status = javaType.status(),
            )
    }
}
