@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ga.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getBasicAccelerateIpEndpointRelations.
 * @property accelerateIpId The ID of the Basic Accelerate IP.
 * @property acceleratorId The ID of the Global Accelerator Basic Accelerator instance.
 * @property endpointId The ID of the Basic Endpoint.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property outputFile
 * @property relations A list of Global Accelerator Basic Accelerate Ip Endpoint Relations. Each element contains the following attributes:
 * @property status The status of the Basic Accelerate Ip Endpoint Relation.
 */
public data class GetBasicAccelerateIpEndpointRelationsResult(
    public val accelerateIpId: String? = null,
    public val acceleratorId: String,
    public val endpointId: String? = null,
    public val id: String,
    public val ids: List<String>,
    public val outputFile: String? = null,
    public val relations: List<GetBasicAccelerateIpEndpointRelationsRelation>,
    public val status: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ga.outputs.GetBasicAccelerateIpEndpointRelationsResult): GetBasicAccelerateIpEndpointRelationsResult = GetBasicAccelerateIpEndpointRelationsResult(
            accelerateIpId = javaType.accelerateIpId().map({ args0 -> args0 }).orElse(null),
            acceleratorId = javaType.acceleratorId(),
            endpointId = javaType.endpointId().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            relations = javaType.relations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.ga.kotlin.outputs.GetBasicAccelerateIpEndpointRelationsRelation.Companion.toKotlin(args0)
                })
            }),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
        )
    }
}
