@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ga.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property accelerateIpAddress The address of the Basic Accelerate IP.
 * @property accelerateIpId The id of the Basic Accelerate IP.
 * @property acceleratorId The id of the Global Accelerator Basic Accelerator instance.
 * @property id The id of the Basic Accelerate IP.
 * @property ipSetId The ID of the Basic Ip Set.
 * @property status The status of the Global Accelerator Basic Accelerate IP instance. Valid Value: `active`, `binding`, `bound`, `unbinding`, `deleting`.
 */
public data class GetBasicAccelerateIpsIp(
    public val accelerateIpAddress: String,
    public val accelerateIpId: String,
    public val acceleratorId: String,
    public val id: String,
    public val ipSetId: String,
    public val status: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ga.outputs.GetBasicAccelerateIpsIp): GetBasicAccelerateIpsIp = GetBasicAccelerateIpsIp(
            accelerateIpAddress = javaType.accelerateIpAddress(),
            accelerateIpId = javaType.accelerateIpId(),
            acceleratorId = javaType.acceleratorId(),
            id = javaType.id(),
            ipSetId = javaType.ipSetId(),
            status = javaType.status(),
        )
    }
}
