@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ga.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getBasicAccelerateIps.
 * @property accelerateIpAddress The address of the Basic Accelerate IP.
 * @property accelerateIpId The id of the Basic Accelerate IP.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property ipSetId The ID of the Basic Ip Set.
 * @property ips A list of Global Accelerator Basic Accelerate IPs. Each element contains the following attributes:
 * @property outputFile
 * @property status The status of the Basic Accelerate IP instance.
 */
public data class GetBasicAccelerateIpsResult(
    public val accelerateIpAddress: String? = null,
    public val accelerateIpId: String? = null,
    public val id: String,
    public val ids: List<String>,
    public val ipSetId: String,
    public val ips: List<GetBasicAccelerateIpsIp>,
    public val outputFile: String? = null,
    public val status: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ga.outputs.GetBasicAccelerateIpsResult): GetBasicAccelerateIpsResult = GetBasicAccelerateIpsResult(
            accelerateIpAddress = javaType.accelerateIpAddress().map({ args0 -> args0 }).orElse(null),
            accelerateIpId = javaType.accelerateIpId().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            ipSetId = javaType.ipSetId(),
            ips = javaType.ips().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.ga.kotlin.outputs.GetBasicAccelerateIpsIp.Companion.toKotlin(args0)
                })
            }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
        )
    }
}
