@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ga.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property bandwidthBillingType The bandwidth billing method.
 * @property basicAcceleratorId The id of the Global Accelerator Basic Accelerator instance.
 * @property basicAcceleratorName The name of the Global Accelerator Basic Accelerator instance.
 * @property basicBandwidthPackages The details about the basic bandwidth plan that is associated with the Global Accelerator Basic Accelerator instance.
 * @property basicEndpointGroupId The ID of the endpoint group that is associated with the Global Accelerator Basic Accelerator instance.
 * @property basicIpSetId The ID of the acceleration region.
 * @property createTime The timestamp that indicates when the Global Accelerator Basic Accelerator instance was created.
 * @property crossDomainBandwidthPackages The details about the cross-region acceleration bandwidth plan that is associated with the Global Accelerator Basic Accelerator instance. **NOTE:** This array is returned only for Global Accelerator Basic Accelerator instances that are created on the International site.
 * @property description The description of the Global Accelerator Basic Accelerator instance.
 * @property expiredTime The timestamp that indicates when the Global Accelerator Basic Accelerator instance was expired.
 * @property id The id of the Global Accelerator Basic Accelerator.
 * @property instanceChargeType The billing method of the Global Accelerator Basic Accelerator instance. Only `PREPAY` is returned, which indicates the subscription billing method.
 * @property regionId The ID of the region where the Global Accelerator Basic Accelerator instance is deployed.
 * @property status The status of the Global Accelerator Basic Accelerator instance. Valid Value: `init`, `active`, `configuring`, `binding`, `unbinding`, `deleting`, `finacialLocked`.
 */
public data class GetBasicAcceleratorsAccelerator(
    public val bandwidthBillingType: String,
    public val basicAcceleratorId: String,
    public val basicAcceleratorName: String,
    public val basicBandwidthPackages: List<GetBasicAcceleratorsAcceleratorBasicBandwidthPackage>,
    public val basicEndpointGroupId: String,
    public val basicIpSetId: String,
    public val createTime: Int,
    public val crossDomainBandwidthPackages: List<GetBasicAcceleratorsAcceleratorCrossDomainBandwidthPackage>,
    public val description: String,
    public val expiredTime: Int,
    public val id: String,
    public val instanceChargeType: String,
    public val regionId: String,
    public val status: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ga.outputs.GetBasicAcceleratorsAccelerator): GetBasicAcceleratorsAccelerator = GetBasicAcceleratorsAccelerator(
            bandwidthBillingType = javaType.bandwidthBillingType(),
            basicAcceleratorId = javaType.basicAcceleratorId(),
            basicAcceleratorName = javaType.basicAcceleratorName(),
            basicBandwidthPackages = javaType.basicBandwidthPackages().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.ga.kotlin.outputs.GetBasicAcceleratorsAcceleratorBasicBandwidthPackage.Companion.toKotlin(args0)
                })
            }),
            basicEndpointGroupId = javaType.basicEndpointGroupId(),
            basicIpSetId = javaType.basicIpSetId(),
            createTime = javaType.createTime(),
            crossDomainBandwidthPackages = javaType.crossDomainBandwidthPackages().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.ga.kotlin.outputs.GetBasicAcceleratorsAcceleratorCrossDomainBandwidthPackage.Companion.toKotlin(args0)
                })
            }),
            description = javaType.description(),
            expiredTime = javaType.expiredTime(),
            id = javaType.id(),
            instanceChargeType = javaType.instanceChargeType(),
            regionId = javaType.regionId(),
            status = javaType.status(),
        )
    }
}
