@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ga.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property bandwidth The bandwidth value of the cross-region acceleration bandwidth plan. Unit: Mbit/s.
 * @property bandwidthType The type of the bandwidth that is provided by the basic bandwidth plan.
 * @property instanceId The ID of the cross-region acceleration bandwidth plan.
 */
public data class GetBasicAcceleratorsAcceleratorBasicBandwidthPackage(
    public val bandwidth: Int,
    public val bandwidthType: String,
    public val instanceId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ga.outputs.GetBasicAcceleratorsAcceleratorBasicBandwidthPackage): GetBasicAcceleratorsAcceleratorBasicBandwidthPackage =
            GetBasicAcceleratorsAcceleratorBasicBandwidthPackage(
                bandwidth = javaType.bandwidth(),
                bandwidthType = javaType.bandwidthType(),
                instanceId = javaType.instanceId(),
            )
    }
}
