@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ga.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getBasicAccelerators.
 * @property acceleratorId
 * @property accelerators A list of Global Accelerator Basic Accelerators. Each element contains the following attributes:
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property nameRegex
 * @property names A list of Global Accelerator Basic Accelerator names.
 * @property outputFile
 * @property pageNumber
 * @property pageSize
 * @property status The status of the Global Accelerator Basic Accelerator instance.
 */
public data class GetBasicAcceleratorsResult(
    public val acceleratorId: String? = null,
    public val accelerators: List<GetBasicAcceleratorsAccelerator>,
    public val id: String,
    public val ids: List<String>,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
    public val pageNumber: Int? = null,
    public val pageSize: Int? = null,
    public val status: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ga.outputs.GetBasicAcceleratorsResult): GetBasicAcceleratorsResult = GetBasicAcceleratorsResult(
            acceleratorId = javaType.acceleratorId().map({ args0 -> args0 }).orElse(null),
            accelerators = javaType.accelerators().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.ga.kotlin.outputs.GetBasicAcceleratorsAccelerator.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            pageNumber = javaType.pageNumber().map({ args0 -> args0 }).orElse(null),
            pageSize = javaType.pageSize().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
        )
    }
}
