@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ga.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property acceleratorId The ID of the Global Accelerator Basic Accelerator instance.
 * @property basicEndpointName The name of the Basic Endpoint.
 * @property endpointAddress The address of the Basic Endpoint.
 * @property endpointGroupId The ID of the Basic Endpoint Group.
 * @property endpointId The ID of the Basic Endpoint.
 * @property endpointSubAddress The sub address of the Basic Endpoint.
 * @property endpointSubAddressType The sub address type of the Basic Endpoint.
 * @property endpointType The type of the Basic Endpoint. Valid values: `ENI`, `SLB`, `ECS` and `NLB`.
 * @property endpointZoneId The zone id of the Basic Endpoint.
 * @property id The id of the Global Accelerator Basic Endpoint. It formats as `<endpoint_group_id>:<endpoint_id>`.
 * @property status The status of the Global Accelerator Basic Endpoint. Valid Value: `init`, `active`, `updating`, `binding`, `unbinding`, `deleting`, `bound`.
 */
public data class GetBasicEndpointsEndpoint(
    public val acceleratorId: String,
    public val basicEndpointName: String,
    public val endpointAddress: String,
    public val endpointGroupId: String,
    public val endpointId: String,
    public val endpointSubAddress: String,
    public val endpointSubAddressType: String,
    public val endpointType: String,
    public val endpointZoneId: String,
    public val id: String,
    public val status: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ga.outputs.GetBasicEndpointsEndpoint): GetBasicEndpointsEndpoint = GetBasicEndpointsEndpoint(
            acceleratorId = javaType.acceleratorId(),
            basicEndpointName = javaType.basicEndpointName(),
            endpointAddress = javaType.endpointAddress(),
            endpointGroupId = javaType.endpointGroupId(),
            endpointId = javaType.endpointId(),
            endpointSubAddress = javaType.endpointSubAddress(),
            endpointSubAddressType = javaType.endpointSubAddressType(),
            endpointType = javaType.endpointType(),
            endpointZoneId = javaType.endpointZoneId(),
            id = javaType.id(),
            status = javaType.status(),
        )
    }
}
