@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ga.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getBasicEndpoints.
 * @property endpointGroupId The ID of the Basic Endpoint Group.
 * @property endpointId The ID of the Basic Endpoint.
 * @property endpointType The type of the Basic Endpoint.
 * @property endpoints A list of Global Accelerator Basic Endpoints. Each element contains the following attributes:
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property name
 * @property nameRegex
 * @property names A list of Global Accelerator Basic Endpoint names.
 * @property outputFile
 * @property status The status of the Basic Endpoint.
 */
public data class GetBasicEndpointsResult(
    public val endpointGroupId: String,
    public val endpointId: String? = null,
    public val endpointType: String? = null,
    public val endpoints: List<GetBasicEndpointsEndpoint>,
    public val id: String,
    public val ids: List<String>,
    public val name: String? = null,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
    public val status: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ga.outputs.GetBasicEndpointsResult): GetBasicEndpointsResult = GetBasicEndpointsResult(
            endpointGroupId = javaType.endpointGroupId(),
            endpointId = javaType.endpointId().map({ args0 -> args0 }).orElse(null),
            endpointType = javaType.endpointType().map({ args0 -> args0 }).orElse(null),
            endpoints = javaType.endpoints().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.ga.kotlin.outputs.GetBasicEndpointsEndpoint.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
        )
    }
}
