@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ga.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property acceleratorId The ID of the GA instance.
 * @property customRoutingEndpointGroupDestinationId The ID of the Custom Routing Endpoint Group Destination.
 * @property endpointGroupId The ID of the endpoint group.
 * @property fromPort The start port of the backend service port range of the endpoint group. The `from_port` value must be smaller than or equal to the `to_port` value. Valid values: `1` to `65499`.
 * @property id The id of the Global Accelerator Custom Routing Endpoint Group Destination. It formats as `<endpoint_group_id>:<custom_routing_endpoint_group_destination_id>`.
 * @property listenerId The ID of the listener.
 * @property protocols The backend service protocol of the endpoint group. Valid values: `TCP`, `UDP`, `TCP, UDP`.
 * @property toPort The end port of the backend service port range of the endpoint group. The `from_port` value must be smaller than or equal to the `to_port` value. Valid values: `1` to `65499`.
 */
public data class GetCustomRoutingEndpointGroupDestinationsCustomRoutingEndpointGroupDestination(
    public val acceleratorId: String,
    public val customRoutingEndpointGroupDestinationId: String,
    public val endpointGroupId: String,
    public val fromPort: Int,
    public val id: String,
    public val listenerId: String,
    public val protocols: List<String>,
    public val toPort: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ga.outputs.GetCustomRoutingEndpointGroupDestinationsCustomRoutingEndpointGroupDestination): GetCustomRoutingEndpointGroupDestinationsCustomRoutingEndpointGroupDestination =
            GetCustomRoutingEndpointGroupDestinationsCustomRoutingEndpointGroupDestination(
                acceleratorId = javaType.acceleratorId(),
                customRoutingEndpointGroupDestinationId = javaType.customRoutingEndpointGroupDestinationId(),
                endpointGroupId = javaType.endpointGroupId(),
                fromPort = javaType.fromPort(),
                id = javaType.id(),
                listenerId = javaType.listenerId(),
                protocols = javaType.protocols().map({ args0 -> args0 }),
                toPort = javaType.toPort(),
            )
    }
}
