@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ga.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getCustomRoutingEndpointGroupDestinations.
 * @property acceleratorId The ID of the GA instance.
 * @property customRoutingEndpointGroupDestinations A list of Custom Routing Endpoint Group Destinations. Each element contains the following attributes:
 * @property endpointGroupId The ID of the Custom Routing Endpoint Group.
 * @property fromPort The start port of the backend service port range of the endpoint group.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property listenerId The ID of the listener.
 * @property outputFile
 * @property pageNumber
 * @property pageSize
 * @property protocols The backend service protocol of the endpoint group.
 * @property toPort The end port of the backend service port range of the endpoint group.
 */
public data class GetCustomRoutingEndpointGroupDestinationsResult(
    public val acceleratorId: String,
    public val customRoutingEndpointGroupDestinations: List<GetCustomRoutingEndpointGroupDestinationsCustomRoutingEndpointGroupDestination>,
    public val endpointGroupId: String? = null,
    public val fromPort: Int? = null,
    public val id: String,
    public val ids: List<String>,
    public val listenerId: String? = null,
    public val outputFile: String? = null,
    public val pageNumber: Int? = null,
    public val pageSize: Int? = null,
    public val protocols: List<String>? = null,
    public val toPort: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ga.outputs.GetCustomRoutingEndpointGroupDestinationsResult): GetCustomRoutingEndpointGroupDestinationsResult =
            GetCustomRoutingEndpointGroupDestinationsResult(
                acceleratorId = javaType.acceleratorId(),
                customRoutingEndpointGroupDestinations = javaType.customRoutingEndpointGroupDestinations().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.alicloud.ga.kotlin.outputs.GetCustomRoutingEndpointGroupDestinationsCustomRoutingEndpointGroupDestination.Companion.toKotlin(args0)
                    })
                }),
                endpointGroupId = javaType.endpointGroupId().map({ args0 -> args0 }).orElse(null),
                fromPort = javaType.fromPort().map({ args0 -> args0 }).orElse(null),
                id = javaType.id(),
                ids = javaType.ids().map({ args0 -> args0 }),
                listenerId = javaType.listenerId().map({ args0 -> args0 }).orElse(null),
                outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
                pageNumber = javaType.pageNumber().map({ args0 -> args0 }).orElse(null),
                pageSize = javaType.pageSize().map({ args0 -> args0 }).orElse(null),
                protocols = javaType.protocols().map({ args0 -> args0 }),
                toPort = javaType.toPort().map({ args0 -> args0 }).orElse(null),
            )
    }
}
