@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ga.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property acceleratorId The ID of the GA instance.
 * @property customRoutingEndpointGroupName The name of the endpoint group.
 * @property description The description of the endpoint group.
 * @property endpointGroupId The ID of the endpoint group.
 * @property endpointGroupIpLists The list of endpoint group IP addresses.
 * @property endpointGroupRegion The ID of the region where the endpoint group is created.
 * @property endpointGroupUnconfirmedIpLists The endpoint group IP addresses to be confirmed after the GA instance is upgraded.
 * @property id The id of the Custom Routing Endpoint Group.
 * @property listenerId The ID of the custom routing listener.
 * @property status The status of the endpoint group. Valid Values: `init`, `active`, `updating`, `deleting`.
 */
public data class GetCustomRoutingEndpointGroupsGroup(
    public val acceleratorId: String,
    public val customRoutingEndpointGroupName: String,
    public val description: String,
    public val endpointGroupId: String,
    public val endpointGroupIpLists: List<String>,
    public val endpointGroupRegion: String,
    public val endpointGroupUnconfirmedIpLists: List<String>,
    public val id: String,
    public val listenerId: String,
    public val status: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ga.outputs.GetCustomRoutingEndpointGroupsGroup): GetCustomRoutingEndpointGroupsGroup = GetCustomRoutingEndpointGroupsGroup(
            acceleratorId = javaType.acceleratorId(),
            customRoutingEndpointGroupName = javaType.customRoutingEndpointGroupName(),
            description = javaType.description(),
            endpointGroupId = javaType.endpointGroupId(),
            endpointGroupIpLists = javaType.endpointGroupIpLists().map({ args0 -> args0 }),
            endpointGroupRegion = javaType.endpointGroupRegion(),
            endpointGroupUnconfirmedIpLists = javaType.endpointGroupUnconfirmedIpLists().map({ args0 ->
                args0
            }),
            id = javaType.id(),
            listenerId = javaType.listenerId(),
            status = javaType.status(),
        )
    }
}
