@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ga.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getCustomRoutingEndpointGroups.
 * @property acceleratorId The ID of the GA instance.
 * @property endpointGroupId The ID of the Custom Routing Endpoint Group.
 * @property groups A list of Custom Routing Endpoint Groups. Each element contains the following attributes:
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property listenerId The ID of the custom routing listener.
 * @property nameRegex
 * @property names A list of Custom Routing Endpoint Group names.
 * @property outputFile
 * @property pageNumber
 * @property pageSize
 * @property status The status of the endpoint group.
 */
public data class GetCustomRoutingEndpointGroupsResult(
    public val acceleratorId: String,
    public val endpointGroupId: String? = null,
    public val groups: List<GetCustomRoutingEndpointGroupsGroup>,
    public val id: String,
    public val ids: List<String>,
    public val listenerId: String? = null,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
    public val pageNumber: Int? = null,
    public val pageSize: Int? = null,
    public val status: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ga.outputs.GetCustomRoutingEndpointGroupsResult): GetCustomRoutingEndpointGroupsResult = GetCustomRoutingEndpointGroupsResult(
            acceleratorId = javaType.acceleratorId(),
            endpointGroupId = javaType.endpointGroupId().map({ args0 -> args0 }).orElse(null),
            groups = javaType.groups().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.ga.kotlin.outputs.GetCustomRoutingEndpointGroupsGroup.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            listenerId = javaType.listenerId().map({ args0 -> args0 }).orElse(null),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            pageNumber = javaType.pageNumber().map({ args0 -> args0 }).orElse(null),
            pageSize = javaType.pageSize().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
        )
    }
}
