@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ga.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property acceleratorId The ID of the GA instance to which the traffic policies belong.
 * @property address The IP addresses of the traffic policies.
 * @property customRoutingEndpointTrafficPolicyId The ID of the Custom Routing Endpoint Traffic Policy.
 * @property endpointGroupId The ID of the endpoint group to which the traffic policies belong.
 * @property endpointId The ID of the endpoint to which the traffic policies belong.
 * @property id The id of the Global Accelerator Custom Routing Endpoint Traffic Policy. It formats as `<endpoint_id>:<custom_routing_endpoint_traffic_policy_id>`.
 * @property listenerId The ID of the listener to which the traffic policies belong.
 * @property portRanges The port range of the traffic policy.
 */
public data class GetCustomRoutingEndpointTrafficPoliciesCustomRoutingEndpointTrafficPolicy(
    public val acceleratorId: String,
    public val address: String,
    public val customRoutingEndpointTrafficPolicyId: String,
    public val endpointGroupId: String,
    public val endpointId: String,
    public val id: String,
    public val listenerId: String,
    public val portRanges: List<GetCustomRoutingEndpointTrafficPoliciesCustomRoutingEndpointTrafficPolicyPortRange>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ga.outputs.GetCustomRoutingEndpointTrafficPoliciesCustomRoutingEndpointTrafficPolicy): GetCustomRoutingEndpointTrafficPoliciesCustomRoutingEndpointTrafficPolicy =
            GetCustomRoutingEndpointTrafficPoliciesCustomRoutingEndpointTrafficPolicy(
                acceleratorId = javaType.acceleratorId(),
                address = javaType.address(),
                customRoutingEndpointTrafficPolicyId = javaType.customRoutingEndpointTrafficPolicyId(),
                endpointGroupId = javaType.endpointGroupId(),
                endpointId = javaType.endpointId(),
                id = javaType.id(),
                listenerId = javaType.listenerId(),
                portRanges = javaType.portRanges().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.alicloud.ga.kotlin.outputs.GetCustomRoutingEndpointTrafficPoliciesCustomRoutingEndpointTrafficPolicyPortRange.Companion.toKotlin(args0)
                    })
                }),
            )
    }
}
