@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ga.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getCustomRoutingEndpointTrafficPolicies.
 * @property acceleratorId The ID of the GA instance to which the endpoint belongs.
 * @property address The IP address of the traffic policy.
 * @property customRoutingEndpointTrafficPolicies A list of Custom Routing Endpoint Traffic Policies. Each element contains the following attributes:
 * @property endpointGroupId The ID of the Custom Routing Endpoint Group.
 * @property endpointId The ID of the Custom Routing Endpoint.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property listenerId The ID of the custom routing listener to which the endpoint belongs.
 * @property outputFile
 * @property pageNumber
 * @property pageSize
 */
public data class GetCustomRoutingEndpointTrafficPoliciesResult(
    public val acceleratorId: String,
    public val address: String? = null,
    public val customRoutingEndpointTrafficPolicies: List<GetCustomRoutingEndpointTrafficPoliciesCustomRoutingEndpointTrafficPolicy>,
    public val endpointGroupId: String? = null,
    public val endpointId: String? = null,
    public val id: String,
    public val ids: List<String>,
    public val listenerId: String? = null,
    public val outputFile: String? = null,
    public val pageNumber: Int? = null,
    public val pageSize: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ga.outputs.GetCustomRoutingEndpointTrafficPoliciesResult): GetCustomRoutingEndpointTrafficPoliciesResult =
            GetCustomRoutingEndpointTrafficPoliciesResult(
                acceleratorId = javaType.acceleratorId(),
                address = javaType.address().map({ args0 -> args0 }).orElse(null),
                customRoutingEndpointTrafficPolicies = javaType.customRoutingEndpointTrafficPolicies().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.alicloud.ga.kotlin.outputs.GetCustomRoutingEndpointTrafficPoliciesCustomRoutingEndpointTrafficPolicy.Companion.toKotlin(args0)
                    })
                }),
                endpointGroupId = javaType.endpointGroupId().map({ args0 -> args0 }).orElse(null),
                endpointId = javaType.endpointId().map({ args0 -> args0 }).orElse(null),
                id = javaType.id(),
                ids = javaType.ids().map({ args0 -> args0 }),
                listenerId = javaType.listenerId().map({ args0 -> args0 }).orElse(null),
                outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
                pageNumber = javaType.pageNumber().map({ args0 -> args0 }).orElse(null),
                pageSize = javaType.pageSize().map({ args0 -> args0 }).orElse(null),
            )
    }
}
