@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ga.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property acceleratorId The ID of the GA instance.
 * @property customRoutingEndpointId The ID of the Custom Routing Endpoint.
 * @property endpoint The ID of the endpoint (vSwitch).
 * @property endpointGroupId The ID of the endpoint group.
 * @property id The id of the Global Accelerator Custom Routing Endpoint. It formats as `<endpoint_group_id>:<custom_routing_endpoint_id>`.
 * @property listenerId The ID of the custom routing listener.
 * @property trafficToEndpointPolicy The access policy of traffic for the specified endpoint.
 * @property type The backend service type of the endpoint.
 */
public data class GetCustomRoutingEndpointsCustomRoutingEndpoint(
    public val acceleratorId: String,
    public val customRoutingEndpointId: String,
    public val endpoint: String,
    public val endpointGroupId: String,
    public val id: String,
    public val listenerId: String,
    public val trafficToEndpointPolicy: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ga.outputs.GetCustomRoutingEndpointsCustomRoutingEndpoint): GetCustomRoutingEndpointsCustomRoutingEndpoint =
            GetCustomRoutingEndpointsCustomRoutingEndpoint(
                acceleratorId = javaType.acceleratorId(),
                customRoutingEndpointId = javaType.customRoutingEndpointId(),
                endpoint = javaType.endpoint(),
                endpointGroupId = javaType.endpointGroupId(),
                id = javaType.id(),
                listenerId = javaType.listenerId(),
                trafficToEndpointPolicy = javaType.trafficToEndpointPolicy(),
                type = javaType.type(),
            )
    }
}
