@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ga.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getCustomRoutingEndpoints.
 * @property acceleratorId The ID of the GA instance with which the endpoint is associated.
 * @property customRoutingEndpoints A list of Custom Routing Endpoints. Each element contains the following attributes:
 * @property endpointGroupId The ID of the Custom Routing Endpoint Group.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property listenerId The ID of the listener with which the endpoint is associated.
 * @property outputFile
 * @property pageNumber
 * @property pageSize
 */
public data class GetCustomRoutingEndpointsResult(
    public val acceleratorId: String,
    public val customRoutingEndpoints: List<GetCustomRoutingEndpointsCustomRoutingEndpoint>,
    public val endpointGroupId: String? = null,
    public val id: String,
    public val ids: List<String>,
    public val listenerId: String? = null,
    public val outputFile: String? = null,
    public val pageNumber: Int? = null,
    public val pageSize: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ga.outputs.GetCustomRoutingEndpointsResult): GetCustomRoutingEndpointsResult = GetCustomRoutingEndpointsResult(
            acceleratorId = javaType.acceleratorId(),
            customRoutingEndpoints = javaType.customRoutingEndpoints().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.ga.kotlin.outputs.GetCustomRoutingEndpointsCustomRoutingEndpoint.Companion.toKotlin(args0)
                })
            }),
            endpointGroupId = javaType.endpointGroupId().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            listenerId = javaType.listenerId().map({ args0 -> args0 }).orElse(null),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            pageNumber = javaType.pageNumber().map({ args0 -> args0 }).orElse(null),
            pageSize = javaType.pageSize().map({ args0 -> args0 }).orElse(null),
        )
    }
}
