@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ga.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property acceleratorId The ID of the GA instance.
 * @property acceleratorPort The acceleration port.
 * @property destinationSocketAddresses The service IP address and port of the backend instance.
 * @property endpointGroupId The ID of the endpoint group.
 * @property endpointGroupRegion The ID of the region in which the endpoint group resides.
 * @property endpointId The ID of the endpoint.
 * @property listenerId The ID of the listener.
 * @property protocols The protocol of the backend service.
 * @property status The access policy of traffic for the backend instance. Valid Values: `allow`, `deny`.
 * @property vswitch The ID of the endpoint (vSwitch).
 */
public data class GetCustomRoutingPortMappingsCustomRoutingPortMapping(
    public val acceleratorId: String,
    public val acceleratorPort: Int,
    public val destinationSocketAddresses: List<GetCustomRoutingPortMappingsCustomRoutingPortMappingDestinationSocketAddress>,
    public val endpointGroupId: String,
    public val endpointGroupRegion: String,
    public val endpointId: String,
    public val listenerId: String,
    public val protocols: List<String>,
    public val status: String,
    public val vswitch: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ga.outputs.GetCustomRoutingPortMappingsCustomRoutingPortMapping): GetCustomRoutingPortMappingsCustomRoutingPortMapping =
            GetCustomRoutingPortMappingsCustomRoutingPortMapping(
                acceleratorId = javaType.acceleratorId(),
                acceleratorPort = javaType.acceleratorPort(),
                destinationSocketAddresses = javaType.destinationSocketAddresses().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.alicloud.ga.kotlin.outputs.GetCustomRoutingPortMappingsCustomRoutingPortMappingDestinationSocketAddress.Companion.toKotlin(args0)
                    })
                }),
                endpointGroupId = javaType.endpointGroupId(),
                endpointGroupRegion = javaType.endpointGroupRegion(),
                endpointId = javaType.endpointId(),
                listenerId = javaType.listenerId(),
                protocols = javaType.protocols().map({ args0 -> args0 }),
                status = javaType.status(),
                vswitch = javaType.vswitch(),
            )
    }
}
