@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ga.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getCustomRoutingPortMappings.
 * @property acceleratorId The ID of the GA instance.
 * @property customRoutingPortMappings A list of Custom Routing Port Mappings. Each element contains the following attributes:
 * @property endpointGroupId The ID of the endpoint group.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property listenerId The ID of the listener.
 * @property outputFile
 * @property pageNumber
 * @property pageSize
 * @property status The access policy of traffic for the backend instance.
 */
public data class GetCustomRoutingPortMappingsResult(
    public val acceleratorId: String,
    public val customRoutingPortMappings: List<GetCustomRoutingPortMappingsCustomRoutingPortMapping>,
    public val endpointGroupId: String? = null,
    public val id: String,
    public val listenerId: String? = null,
    public val outputFile: String? = null,
    public val pageNumber: Int? = null,
    public val pageSize: Int? = null,
    public val status: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ga.outputs.GetCustomRoutingPortMappingsResult): GetCustomRoutingPortMappingsResult = GetCustomRoutingPortMappingsResult(
            acceleratorId = javaType.acceleratorId(),
            customRoutingPortMappings = javaType.customRoutingPortMappings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.ga.kotlin.outputs.GetCustomRoutingPortMappingsCustomRoutingPortMapping.Companion.toKotlin(args0)
                })
            }),
            endpointGroupId = javaType.endpointGroupId().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            listenerId = javaType.listenerId().map({ args0 -> args0 }).orElse(null),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            pageNumber = javaType.pageNumber().map({ args0 -> args0 }).orElse(null),
            pageSize = javaType.pageSize().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
        )
    }
}
