@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ga.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property acceleratorId The ID of the global acceleration instance.
 * @property domain The accelerated domain name to be added. only top-level domain names are supported, such as 'example.com'.
 * @property id The ID of the Ga Domain.
 * @property status The status of the resource. Valid values: `illegal`, `inactive`, `active`, `unknown`.
 */
public data class GetDomainsDomain(
    public val acceleratorId: String,
    public val domain: String,
    public val id: String,
    public val status: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ga.outputs.GetDomainsDomain): GetDomainsDomain = GetDomainsDomain(
            acceleratorId = javaType.acceleratorId(),
            domain = javaType.domain(),
            id = javaType.id(),
            status = javaType.status(),
        )
    }
}
