@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ga.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getDomains.
 * @property acceleratorId The ID of the global acceleration instance.
 * @property domain The accelerated domain name to be added.
 * @property domains A list of Domain Entries. Each element contains the following attributes:
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property outputFile
 * @property pageNumber
 * @property pageSize
 * @property status The status of the resource
 */
public data class GetDomainsResult(
    public val acceleratorId: String? = null,
    public val domain: String? = null,
    public val domains: List<GetDomainsDomain>,
    public val id: String,
    public val ids: List<String>,
    public val outputFile: String? = null,
    public val pageNumber: Int? = null,
    public val pageSize: Int? = null,
    public val status: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ga.outputs.GetDomainsResult): GetDomainsResult = GetDomainsResult(
            acceleratorId = javaType.acceleratorId().map({ args0 -> args0 }).orElse(null),
            domain = javaType.domain().map({ args0 -> args0 }).orElse(null),
            domains = javaType.domains().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.ga.kotlin.outputs.GetDomainsDomain.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            pageNumber = javaType.pageNumber().map({ args0 -> args0 }).orElse(null),
            pageSize = javaType.pageSize().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
        )
    }
}
