@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ga.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getEndpointGroupIpAddressCidrBlocks.
 * @property endpointGroupIpAddressCidrBlocks A list of Endpoint Group Ip Address Cidr Blocks. Each element contains the following attributes:
 * @property endpointGroupRegion The region ID of the endpoint group.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property outputFile
 */
public data class GetEndpointGroupIpAddressCidrBlocksResult(
    public val endpointGroupIpAddressCidrBlocks: List<GetEndpointGroupIpAddressCidrBlocksEndpointGroupIpAddressCidrBlock>,
    public val endpointGroupRegion: String,
    public val id: String,
    public val outputFile: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ga.outputs.GetEndpointGroupIpAddressCidrBlocksResult): GetEndpointGroupIpAddressCidrBlocksResult = GetEndpointGroupIpAddressCidrBlocksResult(
            endpointGroupIpAddressCidrBlocks = javaType.endpointGroupIpAddressCidrBlocks().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.ga.kotlin.outputs.GetEndpointGroupIpAddressCidrBlocksEndpointGroupIpAddressCidrBlock.Companion.toKotlin(args0)
                })
            }),
            endpointGroupRegion = javaType.endpointGroupRegion(),
            id = javaType.id(),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
        )
    }
}
