@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ga.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property description The description of the endpoint group.
 * @property endpointConfigurations The endpointConfigurations of the endpoint group.
 * @property endpointGroupId The endpoint_group_id of the Endpoint Group.
 * @property endpointGroupIpLists (Available since v1.213.1) The list of endpoint group IP addresses.
 * @property endpointGroupRegion The ID of the region where the endpoint group is deployed.
 * @property healthCheckIntervalSeconds The interval between two consecutive health checks. Unit: seconds.
 * @property healthCheckPath The path specified as the destination of the targets for health checks.
 * @property healthCheckPort The port that is used for health checks.
 * @property healthCheckProtocol The protocol that is used to connect to the targets for health checks.
 * @property id The ID of the Endpoint Group.
 * @property listenerId The ID of the listener that is associated with the endpoint group.
 * @property name The name of the endpoint group.
 * @property portOverrides Mapping between listening port and forwarding port of boarding point.
 * @property status The status of the endpoint group. Valid values: `active`, `configuring`, `creating`, `init`.
 * @property thresholdCount The number of consecutive failed heath checks that must occur before the endpoint is deemed unhealthy.
 * @property trafficPercentage The weight of the endpoint group when the corresponding listener is associated with multiple endpoint groups.
 */
public data class GetEndpointGroupsGroup(
    public val description: String,
    public val endpointConfigurations: List<GetEndpointGroupsGroupEndpointConfiguration>,
    public val endpointGroupId: String,
    public val endpointGroupIpLists: List<String>,
    public val endpointGroupRegion: String,
    public val healthCheckIntervalSeconds: Int,
    public val healthCheckPath: String,
    public val healthCheckPort: Int,
    public val healthCheckProtocol: String,
    public val id: String,
    public val listenerId: String,
    public val name: String,
    public val portOverrides: List<GetEndpointGroupsGroupPortOverride>,
    public val status: String,
    public val thresholdCount: Int,
    public val trafficPercentage: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ga.outputs.GetEndpointGroupsGroup): GetEndpointGroupsGroup = GetEndpointGroupsGroup(
            description = javaType.description(),
            endpointConfigurations = javaType.endpointConfigurations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.ga.kotlin.outputs.GetEndpointGroupsGroupEndpointConfiguration.Companion.toKotlin(args0)
                })
            }),
            endpointGroupId = javaType.endpointGroupId(),
            endpointGroupIpLists = javaType.endpointGroupIpLists().map({ args0 -> args0 }),
            endpointGroupRegion = javaType.endpointGroupRegion(),
            healthCheckIntervalSeconds = javaType.healthCheckIntervalSeconds(),
            healthCheckPath = javaType.healthCheckPath(),
            healthCheckPort = javaType.healthCheckPort(),
            healthCheckProtocol = javaType.healthCheckProtocol(),
            id = javaType.id(),
            listenerId = javaType.listenerId(),
            name = javaType.name(),
            portOverrides = javaType.portOverrides().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.ga.kotlin.outputs.GetEndpointGroupsGroupPortOverride.Companion.toKotlin(args0)
                })
            }),
            status = javaType.status(),
            thresholdCount = javaType.thresholdCount(),
            trafficPercentage = javaType.trafficPercentage(),
        )
    }
}
