@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ga.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property enableClientipPreservation Indicates whether client IP addresses are reserved.
 * @property endpoint The IP address or domain name of Endpoint N in the endpoint group.
 * @property probePort Probe Port.
 * @property probeProtocol Probe Protocol.
 * @property type The type of Endpoint N in the endpoint group.
 * @property weight The weight of Endpoint N in the endpoint group.
 */
public data class GetEndpointGroupsGroupEndpointConfiguration(
    public val enableClientipPreservation: Boolean,
    public val endpoint: String,
    public val probePort: Int,
    public val probeProtocol: String,
    public val type: String,
    public val weight: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ga.outputs.GetEndpointGroupsGroupEndpointConfiguration): GetEndpointGroupsGroupEndpointConfiguration = GetEndpointGroupsGroupEndpointConfiguration(
            enableClientipPreservation = javaType.enableClientipPreservation(),
            endpoint = javaType.endpoint(),
            probePort = javaType.probePort(),
            probeProtocol = javaType.probeProtocol(),
            type = javaType.type(),
            weight = javaType.weight(),
        )
    }
}
