@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ga.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getEndpointGroups.
 * @property acceleratorId
 * @property endpointGroupType
 * @property groups A list of Ga Endpoint Groups. Each element contains the following attributes:
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property listenerId The ID of the listener that is associated with the endpoint group.
 * @property nameRegex
 * @property names A list of Endpoint Group names.
 * @property outputFile
 * @property status The status of the endpoint group.
 */
public data class GetEndpointGroupsResult(
    public val acceleratorId: String,
    public val endpointGroupType: String? = null,
    public val groups: List<GetEndpointGroupsGroup>,
    public val id: String,
    public val ids: List<String>,
    public val listenerId: String? = null,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
    public val status: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ga.outputs.GetEndpointGroupsResult): GetEndpointGroupsResult = GetEndpointGroupsResult(
            acceleratorId = javaType.acceleratorId(),
            endpointGroupType = javaType.endpointGroupType().map({ args0 -> args0 }).orElse(null),
            groups = javaType.groups().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.ga.kotlin.outputs.GetEndpointGroupsGroup.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            listenerId = javaType.listenerId().map({ args0 -> args0 }).orElse(null),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
        )
    }
}
