@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ga.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property forwardingRuleId Forwarding Policy ID.
 * @property forwardingRuleName Forwarding policy name. The length of the name is 2-128 English or Chinese characters.
 * @property forwardingRuleStatus Forwarding Policy Status.
 * @property id
 * @property listenerId The ID of the listener.
 * @property priority Forwarding policy priority.
 * @property ruleActions The IP protocol used by the GA instance.
 * `order` - Forwarding priority.
 * `rule_action_type` - Forward action type.
 * `forward_group_config` - Forwarding configuration.
 * `server_group_tuples` - Terminal node group configuration.
 * `endpoint_group_id` - Terminal node group ID.
 * @property ruleConditions Forward action.
 * `rule_condition_type` - Forwarding condition type.
 * `path_config` - Path configuration information.
 * `values` - The length of the path is 1-128 characters.
 * `host_config` - Domain name configuration information.
 * `values` - The domain name is 3-128 characters long.
 */
public data class GetForwardingRulesForwardingRule(
    public val forwardingRuleId: String,
    public val forwardingRuleName: String,
    public val forwardingRuleStatus: String,
    public val id: String,
    public val listenerId: String,
    public val priority: Int,
    public val ruleActions: List<GetForwardingRulesForwardingRuleRuleAction>,
    public val ruleConditions: List<GetForwardingRulesForwardingRuleRuleCondition>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ga.outputs.GetForwardingRulesForwardingRule): GetForwardingRulesForwardingRule = GetForwardingRulesForwardingRule(
            forwardingRuleId = javaType.forwardingRuleId(),
            forwardingRuleName = javaType.forwardingRuleName(),
            forwardingRuleStatus = javaType.forwardingRuleStatus(),
            id = javaType.id(),
            listenerId = javaType.listenerId(),
            priority = javaType.priority(),
            ruleActions = javaType.ruleActions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.ga.kotlin.outputs.GetForwardingRulesForwardingRuleRuleAction.Companion.toKotlin(args0)
                })
            }),
            ruleConditions = javaType.ruleConditions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.ga.kotlin.outputs.GetForwardingRulesForwardingRuleRuleCondition.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
