@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ga.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getForwardingRules.
 * @property acceleratorId
 * @property forwardingRules
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property listenerId
 * @property outputFile
 * @property status
 */
public data class GetForwardingRulesResult(
    public val acceleratorId: String,
    public val forwardingRules: List<GetForwardingRulesForwardingRule>,
    public val id: String,
    public val ids: List<String>,
    public val listenerId: String,
    public val outputFile: String? = null,
    public val status: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ga.outputs.GetForwardingRulesResult): GetForwardingRulesResult = GetForwardingRulesResult(
            acceleratorId = javaType.acceleratorId(),
            forwardingRules = javaType.forwardingRules().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.ga.kotlin.outputs.GetForwardingRulesForwardingRule.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            listenerId = javaType.listenerId(),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
        )
    }
}
