@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ga.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getIpSets.
 * @property acceleratorId
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property outputFile
 * @property sets
 * @property status
 */
public data class GetIpSetsResult(
    public val acceleratorId: String,
    public val id: String,
    public val ids: List<String>,
    public val outputFile: String? = null,
    public val sets: List<GetIpSetsSet>,
    public val status: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ga.outputs.GetIpSetsResult): GetIpSetsResult =
            GetIpSetsResult(
                acceleratorId = javaType.acceleratorId(),
                id = javaType.id(),
                ids = javaType.ids().map({ args0 -> args0 }),
                outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
                sets = javaType.sets().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.alicloud.ga.kotlin.outputs.GetIpSetsSet.Companion.toKotlin(args0)
                    })
                }),
                status = javaType.status().map({ args0 -> args0 }).orElse(null),
            )
    }
}
