@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ga.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property accelerateRegionId The ID of an acceleration region.
 * @property bandwidth The bandwidth allocated to the acceleration region.
 * @property id The ID of the Ip Set.
 * @property ipAddressLists The list of accelerated IP addresses in the acceleration region.
 * @property ipSetId Accelerated area ID.
 * @property ipVersion The IP protocol used by the GA instance.
 * @property status The status of the acceleration region.
 */
public data class GetIpSetsSet(
    public val accelerateRegionId: String,
    public val bandwidth: Int,
    public val id: String,
    public val ipAddressLists: List<String>,
    public val ipSetId: String,
    public val ipVersion: String,
    public val status: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ga.outputs.GetIpSetsSet): GetIpSetsSet =
            GetIpSetsSet(
                accelerateRegionId = javaType.accelerateRegionId(),
                bandwidth = javaType.bandwidth(),
                id = javaType.id(),
                ipAddressLists = javaType.ipAddressLists().map({ args0 -> args0 }),
                ipSetId = javaType.ipSetId(),
                ipVersion = javaType.ipVersion(),
                status = javaType.status(),
            )
    }
}
