@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ga.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property certificates The certificates of the listener.
 * @property clientAffinity The clientAffinity of the listener.
 * @property description The description of the listener.
 * @property id The ID of the Listener.
 * @property listenerId The listenerId of the listener.
 * @property name The name of the listener. The length of the name is 2-128 characters. It starts with uppercase and lowercase letters or Chinese characters. It can contain numbers and underscores and dashes.
 * @property portRanges The portRanges of the listener.
 * @property protocol Type of network transport protocol monitored.
 * @property status The status of the listener.
 */
public data class GetListenersListener(
    public val certificates: List<GetListenersListenerCertificate>,
    public val clientAffinity: String,
    public val description: String,
    public val id: String,
    public val listenerId: String,
    public val name: String,
    public val portRanges: List<GetListenersListenerPortRange>,
    public val protocol: String,
    public val status: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ga.outputs.GetListenersListener): GetListenersListener = GetListenersListener(
            certificates = javaType.certificates().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.ga.kotlin.outputs.GetListenersListenerCertificate.Companion.toKotlin(args0)
                })
            }),
            clientAffinity = javaType.clientAffinity(),
            description = javaType.description(),
            id = javaType.id(),
            listenerId = javaType.listenerId(),
            name = javaType.name(),
            portRanges = javaType.portRanges().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.ga.kotlin.outputs.GetListenersListenerPortRange.Companion.toKotlin(args0)
                })
            }),
            protocol = javaType.protocol(),
            status = javaType.status(),
        )
    }
}
