@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ga.kotlin.outputs

import kotlin.Boolean
import kotlin.Suppress

/**
 *
 * @property forwardedForGaApEnabled Specifies whether to use the GA-AP header to retrieve the information about acceleration regions. Default value: `false`. Valid values:
 * @property forwardedForGaIdEnabled Specifies whether to use the GA-ID header to retrieve the ID of the GA instance. Default value: `false`. Valid values:
 * @property forwardedForPortEnabled Specifies whether to use the GA-X-Forward-Port header to retrieve the listener ports of the GA instance. Default value: `false`. Valid values:
 * @property forwardedForProtoEnabled Specifies whether to use the GA-X-Forward-Proto header to retrieve the listener protocol of the GA instance. Default value: `false`. Valid values:
 * @property realIpEnabled Specifies whether to use the X-Real-IP header to retrieve client IP addresses. Default value: `false`. Valid values:
 */
public data class ListenerForwardedForConfig(
    public val forwardedForGaApEnabled: Boolean? = null,
    public val forwardedForGaIdEnabled: Boolean? = null,
    public val forwardedForPortEnabled: Boolean? = null,
    public val forwardedForProtoEnabled: Boolean? = null,
    public val realIpEnabled: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ga.outputs.ListenerForwardedForConfig): ListenerForwardedForConfig = ListenerForwardedForConfig(
            forwardedForGaApEnabled = javaType.forwardedForGaApEnabled().map({ args0 -> args0 }).orElse(null),
            forwardedForGaIdEnabled = javaType.forwardedForGaIdEnabled().map({ args0 -> args0 }).orElse(null),
            forwardedForPortEnabled = javaType.forwardedForPortEnabled().map({ args0 -> args0 }).orElse(null),
            forwardedForProtoEnabled = javaType.forwardedForProtoEnabled().map({ args0 -> args0 }).orElse(null),
            realIpEnabled = javaType.realIpEnabled().map({ args0 -> args0 }).orElse(null),
        )
    }
}
