@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ga.kotlin.outputs

import kotlin.Int
import kotlin.Suppress

/**
 *
 * @property fromPort The initial listening port used to receive requests and forward them to terminal nodes.
 * @property toPort The end listening port used to receive requests and forward them to terminal nodes.
 */
public data class ListenerPortRange(
    public val fromPort: Int,
    public val toPort: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ga.outputs.ListenerPortRange): ListenerPortRange = ListenerPortRange(
            fromPort = javaType.fromPort(),
            toPort = javaType.toPort(),
        )
    }
}
