@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.governance.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [Account].
 */
@PulumiTagMarker
public class AccountResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AccountArgs = AccountArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AccountArgsBuilder.() -> Unit) {
        val builder = AccountArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Account {
        val builtJavaResource = com.pulumi.alicloud.governance.Account(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Account(builtJavaResource)
    }
}

/**
 *
 * ## Import
 * Governance Account can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:governance/account:Account example <id>
 * ```
 */
public class Account internal constructor(
    override val javaResource: com.pulumi.alicloud.governance.Account,
) : KotlinCustomResource(javaResource, AccountMapper) {
    /**
     * The ID of the enrolled account.
     * - If you are creating a new resource account, this parameter is not required.
     * - If you are enrolling a existing account to account factory, this parameter is required.
     */
    public val accountId: Output<Int>
        get() = javaResource.accountId().applyValue({ args0 -> args0 })

    /**
     * Account name prefix.
     * - This parameter is required if you are creating a new resource account.
     * - If the registration application is applied to an existing account, this parameter does not need to be filled in.
     */
    public val accountNamePrefix: Output<String>?
        get() = javaResource.accountNamePrefix().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The baseline ID.
     * If it is left blank, the system default baseline is used by default.
     */
    public val baselineId: Output<String>
        get() = javaResource.baselineId().applyValue({ args0 -> args0 })

    /**
     * The account display name.
     * - This parameter is required if you are creating a new resource account.
     * - If the registration application is applied to an existing account, this parameter does not need to be filled in.
     */
    public val displayName: Output<String>?
        get() = javaResource.displayName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ID of the parent resource folder.
     * If you want to create a new resource account and leave this parameter blank, the account is created in the Root folder by default.
     * If the registration application is applied to an existing account, this parameter does not need to be filled in.
     */
    public val folderId: Output<String>?
        get() = javaResource.folderId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The ID of the billing account. If you leave this parameter empty, the current account is used as the billing account.
     */
    public val payerAccountId: Output<Int>?
        get() = javaResource.payerAccountId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Account registration status. Value:
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })
}

public object AccountMapper : ResourceMapper<Account> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.governance.Account::class == javaResource::class

    override fun map(javaResource: Resource): Account = Account(
        javaResource as
            com.pulumi.alicloud.governance.Account,
    )
}

/**
 * @see [Account].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Account].
 */
public suspend fun account(name: String, block: suspend AccountResourceBuilder.() -> Unit): Account {
    val builder = AccountResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Account].
 * @param name The _unique_ name of the resulting resource.
 */
public fun account(name: String): Account {
    val builder = AccountResourceBuilder()
    builder.name(name)
    return builder.build()
}
