@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.governance.kotlin

import com.pulumi.alicloud.governance.AccountArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * ## Import
 * Governance Account can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:governance/account:Account example <id>
 * ```
 * @property accountId The ID of the enrolled account.
 * - If you are creating a new resource account, this parameter is not required.
 * - If you are enrolling a existing account to account factory, this parameter is required.
 * @property accountNamePrefix Account name prefix.
 * - This parameter is required if you are creating a new resource account.
 * - If the registration application is applied to an existing account, this parameter does not need to be filled in.
 * @property baselineId The baseline ID.
 * If it is left blank, the system default baseline is used by default.
 * @property displayName The account display name.
 * - This parameter is required if you are creating a new resource account.
 * - If the registration application is applied to an existing account, this parameter does not need to be filled in.
 * @property folderId The ID of the parent resource folder.
 * If you want to create a new resource account and leave this parameter blank, the account is created in the Root folder by default.
 * If the registration application is applied to an existing account, this parameter does not need to be filled in.
 * @property payerAccountId The ID of the billing account. If you leave this parameter empty, the current account is used as the billing account.
 */
public data class AccountArgs(
    public val accountId: Output<Int>? = null,
    public val accountNamePrefix: Output<String>? = null,
    public val baselineId: Output<String>? = null,
    public val displayName: Output<String>? = null,
    public val folderId: Output<String>? = null,
    public val payerAccountId: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.governance.AccountArgs> {
    override fun toJava(): com.pulumi.alicloud.governance.AccountArgs =
        com.pulumi.alicloud.governance.AccountArgs.builder()
            .accountId(accountId?.applyValue({ args0 -> args0 }))
            .accountNamePrefix(accountNamePrefix?.applyValue({ args0 -> args0 }))
            .baselineId(baselineId?.applyValue({ args0 -> args0 }))
            .displayName(displayName?.applyValue({ args0 -> args0 }))
            .folderId(folderId?.applyValue({ args0 -> args0 }))
            .payerAccountId(payerAccountId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AccountArgs].
 */
@PulumiTagMarker
public class AccountArgsBuilder internal constructor() {
    private var accountId: Output<Int>? = null

    private var accountNamePrefix: Output<String>? = null

    private var baselineId: Output<String>? = null

    private var displayName: Output<String>? = null

    private var folderId: Output<String>? = null

    private var payerAccountId: Output<Int>? = null

    /**
     * @param value The ID of the enrolled account.
     * - If you are creating a new resource account, this parameter is not required.
     * - If you are enrolling a existing account to account factory, this parameter is required.
     */
    @JvmName("wevxrsybapfpygum")
    public suspend fun accountId(`value`: Output<Int>) {
        this.accountId = value
    }

    /**
     * @param value Account name prefix.
     * - This parameter is required if you are creating a new resource account.
     * - If the registration application is applied to an existing account, this parameter does not need to be filled in.
     */
    @JvmName("uoyhrynfpojbyang")
    public suspend fun accountNamePrefix(`value`: Output<String>) {
        this.accountNamePrefix = value
    }

    /**
     * @param value The baseline ID.
     * If it is left blank, the system default baseline is used by default.
     */
    @JvmName("skvafyalwerhirob")
    public suspend fun baselineId(`value`: Output<String>) {
        this.baselineId = value
    }

    /**
     * @param value The account display name.
     * - This parameter is required if you are creating a new resource account.
     * - If the registration application is applied to an existing account, this parameter does not need to be filled in.
     */
    @JvmName("oubcbyblsdfudtnk")
    public suspend fun displayName(`value`: Output<String>) {
        this.displayName = value
    }

    /**
     * @param value The ID of the parent resource folder.
     * If you want to create a new resource account and leave this parameter blank, the account is created in the Root folder by default.
     * If the registration application is applied to an existing account, this parameter does not need to be filled in.
     */
    @JvmName("ekhxktrrxxopjvfo")
    public suspend fun folderId(`value`: Output<String>) {
        this.folderId = value
    }

    /**
     * @param value The ID of the billing account. If you leave this parameter empty, the current account is used as the billing account.
     */
    @JvmName("xjjtsbekuijyrewf")
    public suspend fun payerAccountId(`value`: Output<Int>) {
        this.payerAccountId = value
    }

    /**
     * @param value The ID of the enrolled account.
     * - If you are creating a new resource account, this parameter is not required.
     * - If you are enrolling a existing account to account factory, this parameter is required.
     */
    @JvmName("qkcxttpcwdablkex")
    public suspend fun accountId(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountId = mapped
    }

    /**
     * @param value Account name prefix.
     * - This parameter is required if you are creating a new resource account.
     * - If the registration application is applied to an existing account, this parameter does not need to be filled in.
     */
    @JvmName("xxnmunqbmuqqtrex")
    public suspend fun accountNamePrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountNamePrefix = mapped
    }

    /**
     * @param value The baseline ID.
     * If it is left blank, the system default baseline is used by default.
     */
    @JvmName("epyptyawylyovnth")
    public suspend fun baselineId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.baselineId = mapped
    }

    /**
     * @param value The account display name.
     * - This parameter is required if you are creating a new resource account.
     * - If the registration application is applied to an existing account, this parameter does not need to be filled in.
     */
    @JvmName("ajentdknoknowqgm")
    public suspend fun displayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.displayName = mapped
    }

    /**
     * @param value The ID of the parent resource folder.
     * If you want to create a new resource account and leave this parameter blank, the account is created in the Root folder by default.
     * If the registration application is applied to an existing account, this parameter does not need to be filled in.
     */
    @JvmName("flgrufdufwootcbf")
    public suspend fun folderId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.folderId = mapped
    }

    /**
     * @param value The ID of the billing account. If you leave this parameter empty, the current account is used as the billing account.
     */
    @JvmName("ugjiovemrkbgracg")
    public suspend fun payerAccountId(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.payerAccountId = mapped
    }

    internal fun build(): AccountArgs = AccountArgs(
        accountId = accountId,
        accountNamePrefix = accountNamePrefix,
        baselineId = baselineId,
        displayName = displayName,
        folderId = folderId,
        payerAccountId = payerAccountId,
    )
}
