@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.governance.kotlin.inputs

import com.pulumi.alicloud.governance.inputs.BaselineBaselineItemArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property config Baseline item configuration. The format is a JSON string.
 * @property name The baseline item name.
 * @property version The baseline item version.
 */
public data class BaselineBaselineItemArgs(
    public val config: Output<String>? = null,
    public val name: Output<String>? = null,
    public val version: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.governance.inputs.BaselineBaselineItemArgs> {
    override fun toJava(): com.pulumi.alicloud.governance.inputs.BaselineBaselineItemArgs =
        com.pulumi.alicloud.governance.inputs.BaselineBaselineItemArgs.builder()
            .config(config?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .version(version?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BaselineBaselineItemArgs].
 */
@PulumiTagMarker
public class BaselineBaselineItemArgsBuilder internal constructor() {
    private var config: Output<String>? = null

    private var name: Output<String>? = null

    private var version: Output<String>? = null

    /**
     * @param value Baseline item configuration. The format is a JSON string.
     */
    @JvmName("hcwtqviycmetnmep")
    public suspend fun config(`value`: Output<String>) {
        this.config = value
    }

    /**
     * @param value The baseline item name.
     */
    @JvmName("dclbslnstdlyxwyw")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The baseline item version.
     */
    @JvmName("vnqxpbqyvcengbyq")
    public suspend fun version(`value`: Output<String>) {
        this.version = value
    }

    /**
     * @param value Baseline item configuration. The format is a JSON string.
     */
    @JvmName("ccbuselsqrheekpx")
    public suspend fun config(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.config = mapped
    }

    /**
     * @param value The baseline item name.
     */
    @JvmName("avebssshlllgxmsi")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The baseline item version.
     */
    @JvmName("slxqudyyymposyjx")
    public suspend fun version(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.version = mapped
    }

    internal fun build(): BaselineBaselineItemArgs = BaselineBaselineItemArgs(
        config = config,
        name = name,
        version = version,
    )
}
