@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.governance.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property config Baseline item configuration. The format is a JSON string.
 * @property name The baseline item name.
 * @property version The baseline item version.
 */
public data class BaselineBaselineItem(
    public val config: String? = null,
    public val name: String? = null,
    public val version: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.governance.outputs.BaselineBaselineItem): BaselineBaselineItem = BaselineBaselineItem(
            config = javaType.config().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            version = javaType.version().map({ args0 -> args0 }).orElse(null),
        )
    }
}
