@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.gpdb.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [Account].
 */
@PulumiTagMarker
public class AccountResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AccountArgs = AccountArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AccountArgsBuilder.() -> Unit) {
        val builder = AccountArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Account {
        val builtJavaResource = com.pulumi.alicloud.gpdb.Account(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Account(builtJavaResource)
    }
}

/**
 * Provides a GPDB Account resource.
 * For information about GPDB Account and how to use it, see [What is Account](https://www.alibabacloud.com/help/doc-detail/86924.htm).
 * > **NOTE:** Available since v1.142.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const default = alicloud.gpdb.getZones({});
 * const defaultGetNetworks = alicloud.vpc.getNetworks({
 *     nameRegex: "^default-NODELETING$",
 * });
 * const defaultGetSwitches = Promise.all([defaultGetNetworks, _default])&#46;then(([defaultGetNetworks, _default]) => alicloud.vpc.getSwitches({
 *     vpcId: defaultGetNetworks.ids?.[0],
 *     zoneId: _default.ids?.[0],
 * }));
 * const defaultInstance = new alicloud.gpdb.Instance("default", {
 *     dbInstanceCategory: "HighAvailability",
 *     dbInstanceClass: "gpdb.group.segsdx1",
 *     dbInstanceMode: "StorageElastic",
 *     description: name,
 *     engine: "gpdb",
 *     engineVersion: "6.0",
 *     zoneId: _default.then(_default => _default.ids?.[0]),
 *     instanceNetworkType: "VPC",
 *     instanceSpec: "2C16G",
 *     masterNodeNum: 1,
 *     paymentType: "PayAsYouGo",
 *     privateIpAddress: "1.1.1.1",
 *     segStorageType: "cloud_essd",
 *     segNodeNum: 4,
 *     storageSize: 50,
 *     vpcId: defaultGetNetworks.then(defaultGetNetworks => defaultGetNetworks.ids?.[0]),
 *     vswitchId: defaultGetSwitches.then(defaultGetSwitches => defaultGetSwitches.ids?.[0]),
 *     ipWhitelists: [{
 *         securityIpList: "127.0.0.1",
 *     }],
 * });
 * const defaultAccount = new alicloud.gpdb.Account("default", {
 *     accountName: "tf_example",
 *     dbInstanceId: defaultInstance.id,
 *     accountPassword: "Example1234",
 *     accountDescription: "tf_example",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * default = alicloud.gpdb.get_zones()
 * default_get_networks = alicloud.vpc.get_networks(name_regex="^default-NODELETING$")
 * default_get_switches = alicloud.vpc.get_switches(vpc_id=default_get_networks.ids[0],
 *     zone_id=default.ids[0])
 * default_instance = alicloud.gpdb.Instance("default",
 *     db_instance_category="HighAvailability",
 *     db_instance_class="gpdb.group.segsdx1",
 *     db_instance_mode="StorageElastic",
 *     description=name,
 *     engine="gpdb",
 *     engine_version="6.0",
 *     zone_id=default.ids[0],
 *     instance_network_type="VPC",
 *     instance_spec="2C16G",
 *     master_node_num=1,
 *     payment_type="PayAsYouGo",
 *     private_ip_address="1.1.1.1",
 *     seg_storage_type="cloud_essd",
 *     seg_node_num=4,
 *     storage_size=50,
 *     vpc_id=default_get_networks.ids[0],
 *     vswitch_id=default_get_switches.ids[0],
 *     ip_whitelists=[{
 *         "security_ip_list": "127.0.0.1",
 *     }])
 * default_account = alicloud.gpdb.Account("default",
 *     account_name="tf_example",
 *     db_instance_id=default_instance.id,
 *     account_password="Example1234",
 *     account_description="tf_example")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var @default = AliCloud.Gpdb.GetZones.Invoke();
 *     var defaultGetNetworks = AliCloud.Vpc.GetNetworks.Invoke(new()
 *     {
 *         NameRegex = "^default-NODELETING$",
 *     });
 *     var defaultGetSwitches = AliCloud.Vpc.GetSwitches.Invoke(new()
 *     {
 *         VpcId = defaultGetNetworks.Apply(getNetworksResult => getNetworksResult.Ids[0]),
 *         ZoneId = @default.Apply(getZonesResult => getZonesResult.Ids[0]),
 *     });
 *     var defaultInstance = new AliCloud.Gpdb.Instance("default", new()
 *     {
 *         DbInstanceCategory = "HighAvailability",
 *         DbInstanceClass = "gpdb.group.segsdx1",
 *         DbInstanceMode = "StorageElastic",
 *         Description = name,
 *         Engine = "gpdb",
 *         EngineVersion = "6.0",
 *         ZoneId = @default.Apply(@default => @default.Apply(getZonesResult => getZonesResult.Ids[0])),
 *         InstanceNetworkType = "VPC",
 *         InstanceSpec = "2C16G",
 *         MasterNodeNum = 1,
 *         PaymentType = "PayAsYouGo",
 *         PrivateIpAddress = "1.1.1.1",
 *         SegStorageType = "cloud_essd",
 *         SegNodeNum = 4,
 *         StorageSize = 50,
 *         VpcId = defaultGetNetworks.Apply(getNetworksResult => getNetworksResult.Ids[0]),
 *         VswitchId = defaultGetSwitches.Apply(getSwitchesResult => getSwitchesResult.Ids[0]),
 *         IpWhitelists = new[]
 *         {
 *             new AliCloud.Gpdb.Inputs.InstanceIpWhitelistArgs
 *             {
 *                 SecurityIpList = "127.0.0.1",
 *             },
 *         },
 *     });
 *     var defaultAccount = new AliCloud.Gpdb.Account("default", new()
 *     {
 *         AccountName = "tf_example",
 *         DbInstanceId = defaultInstance.Id,
 *         AccountPassword = "Example1234",
 *         AccountDescription = "tf_example",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/gpdb"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_default, err := gpdb.GetZones(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultGetNetworks, err := vpc.GetNetworks(ctx, &vpc.GetNetworksArgs{
 * 			NameRegex: pulumi.StringRef("^default-NODELETING$"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultGetSwitches, err := vpc.GetSwitches(ctx, &vpc.GetSwitchesArgs{
 * 			VpcId:  pulumi.StringRef(defaultGetNetworks.Ids[0]),
 * 			ZoneId: pulumi.StringRef(_default.Ids[0]),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultInstance, err := gpdb.NewInstance(ctx, "default", &gpdb.InstanceArgs{
 * 			DbInstanceCategory:  pulumi.String("HighAvailability"),
 * 			DbInstanceClass:     pulumi.String("gpdb.group.segsdx1"),
 * 			DbInstanceMode:      pulumi.String("StorageElastic"),
 * 			Description:         pulumi.String(name),
 * 			Engine:              pulumi.String("gpdb"),
 * 			EngineVersion:       pulumi.String("6.0"),
 * 			ZoneId:              pulumi.String(_default.Ids[0]),
 * 			InstanceNetworkType: pulumi.String("VPC"),
 * 			InstanceSpec:        pulumi.String("2C16G"),
 * 			MasterNodeNum:       pulumi.Int(1),
 * 			PaymentType:         pulumi.String("PayAsYouGo"),
 * 			PrivateIpAddress:    pulumi.String("1.1.1.1"),
 * 			SegStorageType:      pulumi.String("cloud_essd"),
 * 			SegNodeNum:          pulumi.Int(4),
 * 			StorageSize:         pulumi.Int(50),
 * 			VpcId:               pulumi.String(defaultGetNetworks.Ids[0]),
 * 			VswitchId:           pulumi.String(defaultGetSwitches.Ids[0]),
 * 			IpWhitelists: gpdb.InstanceIpWhitelistArray{
 * 				&gpdb.InstanceIpWhitelistArgs{
 * 					SecurityIpList: pulumi.String("127.0.0.1"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = gpdb.NewAccount(ctx, "default", &gpdb.AccountArgs{
 * 			AccountName:        pulumi.String("tf_example"),
 * 			DbInstanceId:       defaultInstance.ID(),
 * 			AccountPassword:    pulumi.String("Example1234"),
 * 			AccountDescription: pulumi.String("tf_example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.gpdb.GpdbFunctions;
 * import com.pulumi.alicloud.gpdb.inputs.GetZonesArgs;
 * import com.pulumi.alicloud.vpc.VpcFunctions;
 * import com.pulumi.alicloud.vpc.inputs.GetNetworksArgs;
 * import com.pulumi.alicloud.vpc.inputs.GetSwitchesArgs;
 * import com.pulumi.alicloud.gpdb.Instance;
 * import com.pulumi.alicloud.gpdb.InstanceArgs;
 * import com.pulumi.alicloud.gpdb.inputs.InstanceIpWhitelistArgs;
 * import com.pulumi.alicloud.gpdb.Account;
 * import com.pulumi.alicloud.gpdb.AccountArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example");
 *         final var default = GpdbFunctions.getZones();
 *         final var defaultGetNetworks = VpcFunctions.getNetworks(GetNetworksArgs.builder()
 *             .nameRegex("^default-NODELETING$")
 *             .build());
 *         final var defaultGetSwitches = VpcFunctions.getSwitches(GetSwitchesArgs.builder()
 *             .vpcId(defaultGetNetworks.applyValue(getNetworksResult -> getNetworksResult.ids()[0]))
 *             .zoneId(default_.ids()[0])
 *             .build());
 *         var defaultInstance = new Instance("defaultInstance", InstanceArgs.builder()
 *             .dbInstanceCategory("HighAvailability")
 *             .dbInstanceClass("gpdb.group.segsdx1")
 *             .dbInstanceMode("StorageElastic")
 *             .description(name)
 *             .engine("gpdb")
 *             .engineVersion("6.0")
 *             .zoneId(default_.ids()[0])
 *             .instanceNetworkType("VPC")
 *             .instanceSpec("2C16G")
 *             .masterNodeNum(1)
 *             .paymentType("PayAsYouGo")
 *             .privateIpAddress("1.1.1.1")
 *             .segStorageType("cloud_essd")
 *             .segNodeNum(4)
 *             .storageSize(50)
 *             .vpcId(defaultGetNetworks.applyValue(getNetworksResult -> getNetworksResult.ids()[0]))
 *             .vswitchId(defaultGetSwitches.applyValue(getSwitchesResult -> getSwitchesResult.ids()[0]))
 *             .ipWhitelists(InstanceIpWhitelistArgs.builder()
 *                 .securityIpList("127.0.0.1")
 *                 .build())
 *             .build());
 *         var defaultAccount = new Account("defaultAccount", AccountArgs.builder()
 *             .accountName("tf_example")
 *             .dbInstanceId(defaultInstance.id())
 *             .accountPassword("Example1234")
 *             .accountDescription("tf_example")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform-example
 * resources:
 *   defaultInstance:
 *     type: alicloud:gpdb:Instance
 *     name: default
 *     properties:
 *       dbInstanceCategory: HighAvailability
 *       dbInstanceClass: gpdb.group.segsdx1
 *       dbInstanceMode: StorageElastic
 *       description: ${name}
 *       engine: gpdb
 *       engineVersion: '6.0'
 *       zoneId: ${default.ids[0]}
 *       instanceNetworkType: VPC
 *       instanceSpec: 2C16G
 *       masterNodeNum: 1
 *       paymentType: PayAsYouGo
 *       privateIpAddress: 1.1.1.1
 *       segStorageType: cloud_essd
 *       segNodeNum: 4
 *       storageSize: 50
 *       vpcId: ${defaultGetNetworks.ids[0]}
 *       vswitchId: ${defaultGetSwitches.ids[0]}
 *       ipWhitelists:
 *         - securityIpList: 127.0.0.1
 *   defaultAccount:
 *     type: alicloud:gpdb:Account
 *     name: default
 *     properties:
 *       accountName: tf_example
 *       dbInstanceId: ${defaultInstance.id}
 *       accountPassword: Example1234
 *       accountDescription: tf_example
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:gpdb:getZones
 *       Arguments: {}
 *   defaultGetNetworks:
 *     fn::invoke:
 *       Function: alicloud:vpc:getNetworks
 *       Arguments:
 *         nameRegex: ^default-NODELETING$
 *   defaultGetSwitches:
 *     fn::invoke:
 *       Function: alicloud:vpc:getSwitches
 *       Arguments:
 *         vpcId: ${defaultGetNetworks.ids[0]}
 *         zoneId: ${default.ids[0]}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * GPDB Account can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:gpdb/account:Account example <db_instance_id>:<account_name>
 * ```
 */
public class Account internal constructor(
    override val javaResource: com.pulumi.alicloud.gpdb.Account,
) : KotlinCustomResource(javaResource, AccountMapper) {
    /**
     * The description of the account.
     * * Starts with a letter.
     * * Does not start with `http://` or `https://`.
     * * Contains letters, underscores (_), hyphens (-), or digits.
     * * Be 2 to 256 characters in length.
     */
    public val accountDescription: Output<String>?
        get() = javaResource.accountDescription().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the account. The account name must be unique and meet the following requirements:
     * * Starts with a letter.
     * * Contains only lowercase letters, digits, or underscores (_).
     * * Be up to 16 characters in length.
     * * Contains no reserved keywords.
     */
    public val accountName: Output<String>
        get() = javaResource.accountName().applyValue({ args0 -> args0 })

    /**
     * The password of the account. The password must be 8 to 32 characters in length and contain at least three of the following character types: uppercase letters, lowercase letters, digits, and special characters. Special characters include `! @ # $ % ^ & * ( ) _ + - =`.
     */
    public val accountPassword: Output<String>
        get() = javaResource.accountPassword().applyValue({ args0 -> args0 })

    /**
     * The ID of the instance.
     */
    public val dbInstanceId: Output<String>
        get() = javaResource.dbInstanceId().applyValue({ args0 -> args0 })

    /**
     * The status of the account. Valid values: `Active`, `Creating` and `Deleting`.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })
}

public object AccountMapper : ResourceMapper<Account> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.gpdb.Account::class == javaResource::class

    override fun map(javaResource: Resource): Account = Account(
        javaResource as
            com.pulumi.alicloud.gpdb.Account,
    )
}

/**
 * @see [Account].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Account].
 */
public suspend fun account(name: String, block: suspend AccountResourceBuilder.() -> Unit): Account {
    val builder = AccountResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Account].
 * @param name The _unique_ name of the resulting resource.
 */
public fun account(name: String): Account {
    val builder = AccountResourceBuilder()
    builder.name(name)
    return builder.build()
}
