@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.gpdb.kotlin

import com.pulumi.alicloud.gpdb.AccountArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a GPDB Account resource.
 * For information about GPDB Account and how to use it, see [What is Account](https://www.alibabacloud.com/help/doc-detail/86924.htm).
 * > **NOTE:** Available since v1.142.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const default = alicloud.gpdb.getZones({});
 * const defaultGetNetworks = alicloud.vpc.getNetworks({
 *     nameRegex: "^default-NODELETING$",
 * });
 * const defaultGetSwitches = Promise.all([defaultGetNetworks, _default])&#46;then(([defaultGetNetworks, _default]) => alicloud.vpc.getSwitches({
 *     vpcId: defaultGetNetworks.ids?.[0],
 *     zoneId: _default.ids?.[0],
 * }));
 * const defaultInstance = new alicloud.gpdb.Instance("default", {
 *     dbInstanceCategory: "HighAvailability",
 *     dbInstanceClass: "gpdb.group.segsdx1",
 *     dbInstanceMode: "StorageElastic",
 *     description: name,
 *     engine: "gpdb",
 *     engineVersion: "6.0",
 *     zoneId: _default.then(_default => _default.ids?.[0]),
 *     instanceNetworkType: "VPC",
 *     instanceSpec: "2C16G",
 *     masterNodeNum: 1,
 *     paymentType: "PayAsYouGo",
 *     privateIpAddress: "1.1.1.1",
 *     segStorageType: "cloud_essd",
 *     segNodeNum: 4,
 *     storageSize: 50,
 *     vpcId: defaultGetNetworks.then(defaultGetNetworks => defaultGetNetworks.ids?.[0]),
 *     vswitchId: defaultGetSwitches.then(defaultGetSwitches => defaultGetSwitches.ids?.[0]),
 *     ipWhitelists: [{
 *         securityIpList: "127.0.0.1",
 *     }],
 * });
 * const defaultAccount = new alicloud.gpdb.Account("default", {
 *     accountName: "tf_example",
 *     dbInstanceId: defaultInstance.id,
 *     accountPassword: "Example1234",
 *     accountDescription: "tf_example",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * default = alicloud.gpdb.get_zones()
 * default_get_networks = alicloud.vpc.get_networks(name_regex="^default-NODELETING$")
 * default_get_switches = alicloud.vpc.get_switches(vpc_id=default_get_networks.ids[0],
 *     zone_id=default.ids[0])
 * default_instance = alicloud.gpdb.Instance("default",
 *     db_instance_category="HighAvailability",
 *     db_instance_class="gpdb.group.segsdx1",
 *     db_instance_mode="StorageElastic",
 *     description=name,
 *     engine="gpdb",
 *     engine_version="6.0",
 *     zone_id=default.ids[0],
 *     instance_network_type="VPC",
 *     instance_spec="2C16G",
 *     master_node_num=1,
 *     payment_type="PayAsYouGo",
 *     private_ip_address="1.1.1.1",
 *     seg_storage_type="cloud_essd",
 *     seg_node_num=4,
 *     storage_size=50,
 *     vpc_id=default_get_networks.ids[0],
 *     vswitch_id=default_get_switches.ids[0],
 *     ip_whitelists=[{
 *         "security_ip_list": "127.0.0.1",
 *     }])
 * default_account = alicloud.gpdb.Account("default",
 *     account_name="tf_example",
 *     db_instance_id=default_instance.id,
 *     account_password="Example1234",
 *     account_description="tf_example")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var @default = AliCloud.Gpdb.GetZones.Invoke();
 *     var defaultGetNetworks = AliCloud.Vpc.GetNetworks.Invoke(new()
 *     {
 *         NameRegex = "^default-NODELETING$",
 *     });
 *     var defaultGetSwitches = AliCloud.Vpc.GetSwitches.Invoke(new()
 *     {
 *         VpcId = defaultGetNetworks.Apply(getNetworksResult => getNetworksResult.Ids[0]),
 *         ZoneId = @default.Apply(getZonesResult => getZonesResult.Ids[0]),
 *     });
 *     var defaultInstance = new AliCloud.Gpdb.Instance("default", new()
 *     {
 *         DbInstanceCategory = "HighAvailability",
 *         DbInstanceClass = "gpdb.group.segsdx1",
 *         DbInstanceMode = "StorageElastic",
 *         Description = name,
 *         Engine = "gpdb",
 *         EngineVersion = "6.0",
 *         ZoneId = @default.Apply(@default => @default.Apply(getZonesResult => getZonesResult.Ids[0])),
 *         InstanceNetworkType = "VPC",
 *         InstanceSpec = "2C16G",
 *         MasterNodeNum = 1,
 *         PaymentType = "PayAsYouGo",
 *         PrivateIpAddress = "1.1.1.1",
 *         SegStorageType = "cloud_essd",
 *         SegNodeNum = 4,
 *         StorageSize = 50,
 *         VpcId = defaultGetNetworks.Apply(getNetworksResult => getNetworksResult.Ids[0]),
 *         VswitchId = defaultGetSwitches.Apply(getSwitchesResult => getSwitchesResult.Ids[0]),
 *         IpWhitelists = new[]
 *         {
 *             new AliCloud.Gpdb.Inputs.InstanceIpWhitelistArgs
 *             {
 *                 SecurityIpList = "127.0.0.1",
 *             },
 *         },
 *     });
 *     var defaultAccount = new AliCloud.Gpdb.Account("default", new()
 *     {
 *         AccountName = "tf_example",
 *         DbInstanceId = defaultInstance.Id,
 *         AccountPassword = "Example1234",
 *         AccountDescription = "tf_example",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/gpdb"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_default, err := gpdb.GetZones(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultGetNetworks, err := vpc.GetNetworks(ctx, &vpc.GetNetworksArgs{
 * 			NameRegex: pulumi.StringRef("^default-NODELETING$"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultGetSwitches, err := vpc.GetSwitches(ctx, &vpc.GetSwitchesArgs{
 * 			VpcId:  pulumi.StringRef(defaultGetNetworks.Ids[0]),
 * 			ZoneId: pulumi.StringRef(_default.Ids[0]),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultInstance, err := gpdb.NewInstance(ctx, "default", &gpdb.InstanceArgs{
 * 			DbInstanceCategory:  pulumi.String("HighAvailability"),
 * 			DbInstanceClass:     pulumi.String("gpdb.group.segsdx1"),
 * 			DbInstanceMode:      pulumi.String("StorageElastic"),
 * 			Description:         pulumi.String(name),
 * 			Engine:              pulumi.String("gpdb"),
 * 			EngineVersion:       pulumi.String("6.0"),
 * 			ZoneId:              pulumi.String(_default.Ids[0]),
 * 			InstanceNetworkType: pulumi.String("VPC"),
 * 			InstanceSpec:        pulumi.String("2C16G"),
 * 			MasterNodeNum:       pulumi.Int(1),
 * 			PaymentType:         pulumi.String("PayAsYouGo"),
 * 			PrivateIpAddress:    pulumi.String("1.1.1.1"),
 * 			SegStorageType:      pulumi.String("cloud_essd"),
 * 			SegNodeNum:          pulumi.Int(4),
 * 			StorageSize:         pulumi.Int(50),
 * 			VpcId:               pulumi.String(defaultGetNetworks.Ids[0]),
 * 			VswitchId:           pulumi.String(defaultGetSwitches.Ids[0]),
 * 			IpWhitelists: gpdb.InstanceIpWhitelistArray{
 * 				&gpdb.InstanceIpWhitelistArgs{
 * 					SecurityIpList: pulumi.String("127.0.0.1"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = gpdb.NewAccount(ctx, "default", &gpdb.AccountArgs{
 * 			AccountName:        pulumi.String("tf_example"),
 * 			DbInstanceId:       defaultInstance.ID(),
 * 			AccountPassword:    pulumi.String("Example1234"),
 * 			AccountDescription: pulumi.String("tf_example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.gpdb.GpdbFunctions;
 * import com.pulumi.alicloud.gpdb.inputs.GetZonesArgs;
 * import com.pulumi.alicloud.vpc.VpcFunctions;
 * import com.pulumi.alicloud.vpc.inputs.GetNetworksArgs;
 * import com.pulumi.alicloud.vpc.inputs.GetSwitchesArgs;
 * import com.pulumi.alicloud.gpdb.Instance;
 * import com.pulumi.alicloud.gpdb.InstanceArgs;
 * import com.pulumi.alicloud.gpdb.inputs.InstanceIpWhitelistArgs;
 * import com.pulumi.alicloud.gpdb.Account;
 * import com.pulumi.alicloud.gpdb.AccountArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example");
 *         final var default = GpdbFunctions.getZones();
 *         final var defaultGetNetworks = VpcFunctions.getNetworks(GetNetworksArgs.builder()
 *             .nameRegex("^default-NODELETING$")
 *             .build());
 *         final var defaultGetSwitches = VpcFunctions.getSwitches(GetSwitchesArgs.builder()
 *             .vpcId(defaultGetNetworks.applyValue(getNetworksResult -> getNetworksResult.ids()[0]))
 *             .zoneId(default_.ids()[0])
 *             .build());
 *         var defaultInstance = new Instance("defaultInstance", InstanceArgs.builder()
 *             .dbInstanceCategory("HighAvailability")
 *             .dbInstanceClass("gpdb.group.segsdx1")
 *             .dbInstanceMode("StorageElastic")
 *             .description(name)
 *             .engine("gpdb")
 *             .engineVersion("6.0")
 *             .zoneId(default_.ids()[0])
 *             .instanceNetworkType("VPC")
 *             .instanceSpec("2C16G")
 *             .masterNodeNum(1)
 *             .paymentType("PayAsYouGo")
 *             .privateIpAddress("1.1.1.1")
 *             .segStorageType("cloud_essd")
 *             .segNodeNum(4)
 *             .storageSize(50)
 *             .vpcId(defaultGetNetworks.applyValue(getNetworksResult -> getNetworksResult.ids()[0]))
 *             .vswitchId(defaultGetSwitches.applyValue(getSwitchesResult -> getSwitchesResult.ids()[0]))
 *             .ipWhitelists(InstanceIpWhitelistArgs.builder()
 *                 .securityIpList("127.0.0.1")
 *                 .build())
 *             .build());
 *         var defaultAccount = new Account("defaultAccount", AccountArgs.builder()
 *             .accountName("tf_example")
 *             .dbInstanceId(defaultInstance.id())
 *             .accountPassword("Example1234")
 *             .accountDescription("tf_example")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform-example
 * resources:
 *   defaultInstance:
 *     type: alicloud:gpdb:Instance
 *     name: default
 *     properties:
 *       dbInstanceCategory: HighAvailability
 *       dbInstanceClass: gpdb.group.segsdx1
 *       dbInstanceMode: StorageElastic
 *       description: ${name}
 *       engine: gpdb
 *       engineVersion: '6.0'
 *       zoneId: ${default.ids[0]}
 *       instanceNetworkType: VPC
 *       instanceSpec: 2C16G
 *       masterNodeNum: 1
 *       paymentType: PayAsYouGo
 *       privateIpAddress: 1.1.1.1
 *       segStorageType: cloud_essd
 *       segNodeNum: 4
 *       storageSize: 50
 *       vpcId: ${defaultGetNetworks.ids[0]}
 *       vswitchId: ${defaultGetSwitches.ids[0]}
 *       ipWhitelists:
 *         - securityIpList: 127.0.0.1
 *   defaultAccount:
 *     type: alicloud:gpdb:Account
 *     name: default
 *     properties:
 *       accountName: tf_example
 *       dbInstanceId: ${defaultInstance.id}
 *       accountPassword: Example1234
 *       accountDescription: tf_example
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:gpdb:getZones
 *       Arguments: {}
 *   defaultGetNetworks:
 *     fn::invoke:
 *       Function: alicloud:vpc:getNetworks
 *       Arguments:
 *         nameRegex: ^default-NODELETING$
 *   defaultGetSwitches:
 *     fn::invoke:
 *       Function: alicloud:vpc:getSwitches
 *       Arguments:
 *         vpcId: ${defaultGetNetworks.ids[0]}
 *         zoneId: ${default.ids[0]}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * GPDB Account can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:gpdb/account:Account example <db_instance_id>:<account_name>
 * ```
 * @property accountDescription The description of the account.
 * * Starts with a letter.
 * * Does not start with `http://` or `https://`.
 * * Contains letters, underscores (_), hyphens (-), or digits.
 * * Be 2 to 256 characters in length.
 * @property accountName The name of the account. The account name must be unique and meet the following requirements:
 * * Starts with a letter.
 * * Contains only lowercase letters, digits, or underscores (_).
 * * Be up to 16 characters in length.
 * * Contains no reserved keywords.
 * @property accountPassword The password of the account. The password must be 8 to 32 characters in length and contain at least three of the following character types: uppercase letters, lowercase letters, digits, and special characters. Special characters include `! @ # $ % ^ & * ( ) _ + - =`.
 * @property dbInstanceId The ID of the instance.
 */
public data class AccountArgs(
    public val accountDescription: Output<String>? = null,
    public val accountName: Output<String>? = null,
    public val accountPassword: Output<String>? = null,
    public val dbInstanceId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.gpdb.AccountArgs> {
    override fun toJava(): com.pulumi.alicloud.gpdb.AccountArgs =
        com.pulumi.alicloud.gpdb.AccountArgs.builder()
            .accountDescription(accountDescription?.applyValue({ args0 -> args0 }))
            .accountName(accountName?.applyValue({ args0 -> args0 }))
            .accountPassword(accountPassword?.applyValue({ args0 -> args0 }))
            .dbInstanceId(dbInstanceId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AccountArgs].
 */
@PulumiTagMarker
public class AccountArgsBuilder internal constructor() {
    private var accountDescription: Output<String>? = null

    private var accountName: Output<String>? = null

    private var accountPassword: Output<String>? = null

    private var dbInstanceId: Output<String>? = null

    /**
     * @param value The description of the account.
     * * Starts with a letter.
     * * Does not start with `http://` or `https://`.
     * * Contains letters, underscores (_), hyphens (-), or digits.
     * * Be 2 to 256 characters in length.
     */
    @JvmName("obxssdwrdmpwfdva")
    public suspend fun accountDescription(`value`: Output<String>) {
        this.accountDescription = value
    }

    /**
     * @param value The name of the account. The account name must be unique and meet the following requirements:
     * * Starts with a letter.
     * * Contains only lowercase letters, digits, or underscores (_).
     * * Be up to 16 characters in length.
     * * Contains no reserved keywords.
     */
    @JvmName("elfxkveddbhawwfp")
    public suspend fun accountName(`value`: Output<String>) {
        this.accountName = value
    }

    /**
     * @param value The password of the account. The password must be 8 to 32 characters in length and contain at least three of the following character types: uppercase letters, lowercase letters, digits, and special characters. Special characters include `! @ # $ % ^ & * ( ) _ + - =`.
     */
    @JvmName("spvvnjkvwdxdddux")
    public suspend fun accountPassword(`value`: Output<String>) {
        this.accountPassword = value
    }

    /**
     * @param value The ID of the instance.
     */
    @JvmName("kehykdpeqnttswnt")
    public suspend fun dbInstanceId(`value`: Output<String>) {
        this.dbInstanceId = value
    }

    /**
     * @param value The description of the account.
     * * Starts with a letter.
     * * Does not start with `http://` or `https://`.
     * * Contains letters, underscores (_), hyphens (-), or digits.
     * * Be 2 to 256 characters in length.
     */
    @JvmName("fwrahnxxowcamxwa")
    public suspend fun accountDescription(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountDescription = mapped
    }

    /**
     * @param value The name of the account. The account name must be unique and meet the following requirements:
     * * Starts with a letter.
     * * Contains only lowercase letters, digits, or underscores (_).
     * * Be up to 16 characters in length.
     * * Contains no reserved keywords.
     */
    @JvmName("axjmdtbocmtqytms")
    public suspend fun accountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountName = mapped
    }

    /**
     * @param value The password of the account. The password must be 8 to 32 characters in length and contain at least three of the following character types: uppercase letters, lowercase letters, digits, and special characters. Special characters include `! @ # $ % ^ & * ( ) _ + - =`.
     */
    @JvmName("towggfaapcweemvh")
    public suspend fun accountPassword(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountPassword = mapped
    }

    /**
     * @param value The ID of the instance.
     */
    @JvmName("drklfbhbnevtmtjb")
    public suspend fun dbInstanceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dbInstanceId = mapped
    }

    internal fun build(): AccountArgs = AccountArgs(
        accountDescription = accountDescription,
        accountName = accountName,
        accountPassword = accountPassword,
        dbInstanceId = dbInstanceId,
    )
}
