@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.gpdb.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [BackupPolicy].
 */
@PulumiTagMarker
public class BackupPolicyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: BackupPolicyArgs = BackupPolicyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend BackupPolicyArgsBuilder.() -> Unit) {
        val builder = BackupPolicyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): BackupPolicy {
        val builtJavaResource = com.pulumi.alicloud.gpdb.BackupPolicy(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return BackupPolicy(builtJavaResource)
    }
}

/**
 *
 * ## Import
 * GPDB Backup Policy can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:gpdb/backupPolicy:BackupPolicy example <id>
 * ```
 */
public class BackupPolicy internal constructor(
    override val javaResource: com.pulumi.alicloud.gpdb.BackupPolicy,
) : KotlinCustomResource(javaResource, BackupPolicyMapper) {
    /**
     * Data backup retention days.
     */
    public val backupRetentionPeriod: Output<Int>
        get() = javaResource.backupRetentionPeriod().applyValue({ args0 -> args0 })

    /**
     * The instance ID.
     * > **NOTE:**  You can call the DescribeDBInstances operation to view the details of all AnalyticDB PostgreSQL instances in the target region, including the instance ID.
     */
    public val dbInstanceId: Output<String>
        get() = javaResource.dbInstanceId().applyValue({ args0 -> args0 })

    /**
     * Whether to enable automatic recovery points. Value Description:
     * - **true**: enabled.
     * - **false**: Closed.
     */
    public val enableRecoveryPoint: Output<Boolean>
        get() = javaResource.enableRecoveryPoint().applyValue({ args0 -> args0 })

    /**
     * Data backup cycle. Separate multiple values with commas (,). Value Description:
     * - **Monday**: Monday.
     * - **Tuesday**: Tuesday.
     * - **Wednesday**: Wednesday.
     * - **Thursday**: Thursday.
     * - **Friday**: Friday.
     * - **Saturday**: Saturday.
     * - **Sunday**: Sunday.
     */
    public val preferredBackupPeriod: Output<String>
        get() = javaResource.preferredBackupPeriod().applyValue({ args0 -> args0 })

    /**
     * Data backup time. Format: HH:mmZ-HH:mmZ(UTC time).
     */
    public val preferredBackupTime: Output<String>
        get() = javaResource.preferredBackupTime().applyValue({ args0 -> args0 })

    /**
     * Recovery point frequency. Value Description:
     * - **1**: Hourly.
     * - **2**: Every two hours.
     * - **4**: Every four hours.
     * - **8**: Every eight hours.
     */
    public val recoveryPointPeriod: Output<String>
        get() = javaResource.recoveryPointPeriod().applyValue({ args0 -> args0 })
}

public object BackupPolicyMapper : ResourceMapper<BackupPolicy> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.gpdb.BackupPolicy::class == javaResource::class

    override fun map(javaResource: Resource): BackupPolicy = BackupPolicy(
        javaResource as
            com.pulumi.alicloud.gpdb.BackupPolicy,
    )
}

/**
 * @see [BackupPolicy].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [BackupPolicy].
 */
public suspend fun backupPolicy(
    name: String,
    block: suspend BackupPolicyResourceBuilder.() -> Unit,
): BackupPolicy {
    val builder = BackupPolicyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [BackupPolicy].
 * @param name The _unique_ name of the resulting resource.
 */
public fun backupPolicy(name: String): BackupPolicy {
    val builder = BackupPolicyResourceBuilder()
    builder.name(name)
    return builder.build()
}
