@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.gpdb.kotlin

import com.pulumi.alicloud.gpdb.BackupPolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * ## Import
 * GPDB Backup Policy can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:gpdb/backupPolicy:BackupPolicy example <id>
 * ```
 * @property backupRetentionPeriod Data backup retention days.
 * @property dbInstanceId The instance ID.
 * > **NOTE:**  You can call the DescribeDBInstances operation to view the details of all AnalyticDB PostgreSQL instances in the target region, including the instance ID.
 * @property enableRecoveryPoint Whether to enable automatic recovery points. Value Description:
 * - **true**: enabled.
 * - **false**: Closed.
 * @property preferredBackupPeriod Data backup cycle. Separate multiple values with commas (,). Value Description:
 * - **Monday**: Monday.
 * - **Tuesday**: Tuesday.
 * - **Wednesday**: Wednesday.
 * - **Thursday**: Thursday.
 * - **Friday**: Friday.
 * - **Saturday**: Saturday.
 * - **Sunday**: Sunday.
 * @property preferredBackupTime Data backup time. Format: HH:mmZ-HH:mmZ(UTC time).
 * @property recoveryPointPeriod Recovery point frequency. Value Description:
 * - **1**: Hourly.
 * - **2**: Every two hours.
 * - **4**: Every four hours.
 * - **8**: Every eight hours.
 */
public data class BackupPolicyArgs(
    public val backupRetentionPeriod: Output<Int>? = null,
    public val dbInstanceId: Output<String>? = null,
    public val enableRecoveryPoint: Output<Boolean>? = null,
    public val preferredBackupPeriod: Output<String>? = null,
    public val preferredBackupTime: Output<String>? = null,
    public val recoveryPointPeriod: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.gpdb.BackupPolicyArgs> {
    override fun toJava(): com.pulumi.alicloud.gpdb.BackupPolicyArgs =
        com.pulumi.alicloud.gpdb.BackupPolicyArgs.builder()
            .backupRetentionPeriod(backupRetentionPeriod?.applyValue({ args0 -> args0 }))
            .dbInstanceId(dbInstanceId?.applyValue({ args0 -> args0 }))
            .enableRecoveryPoint(enableRecoveryPoint?.applyValue({ args0 -> args0 }))
            .preferredBackupPeriod(preferredBackupPeriod?.applyValue({ args0 -> args0 }))
            .preferredBackupTime(preferredBackupTime?.applyValue({ args0 -> args0 }))
            .recoveryPointPeriod(recoveryPointPeriod?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BackupPolicyArgs].
 */
@PulumiTagMarker
public class BackupPolicyArgsBuilder internal constructor() {
    private var backupRetentionPeriod: Output<Int>? = null

    private var dbInstanceId: Output<String>? = null

    private var enableRecoveryPoint: Output<Boolean>? = null

    private var preferredBackupPeriod: Output<String>? = null

    private var preferredBackupTime: Output<String>? = null

    private var recoveryPointPeriod: Output<String>? = null

    /**
     * @param value Data backup retention days.
     */
    @JvmName("ipyiissceyjluqgs")
    public suspend fun backupRetentionPeriod(`value`: Output<Int>) {
        this.backupRetentionPeriod = value
    }

    /**
     * @param value The instance ID.
     * > **NOTE:**  You can call the DescribeDBInstances operation to view the details of all AnalyticDB PostgreSQL instances in the target region, including the instance ID.
     */
    @JvmName("kbxcgnxkiqgdsikr")
    public suspend fun dbInstanceId(`value`: Output<String>) {
        this.dbInstanceId = value
    }

    /**
     * @param value Whether to enable automatic recovery points. Value Description:
     * - **true**: enabled.
     * - **false**: Closed.
     */
    @JvmName("mpdgtxrsdqmiqaja")
    public suspend fun enableRecoveryPoint(`value`: Output<Boolean>) {
        this.enableRecoveryPoint = value
    }

    /**
     * @param value Data backup cycle. Separate multiple values with commas (,). Value Description:
     * - **Monday**: Monday.
     * - **Tuesday**: Tuesday.
     * - **Wednesday**: Wednesday.
     * - **Thursday**: Thursday.
     * - **Friday**: Friday.
     * - **Saturday**: Saturday.
     * - **Sunday**: Sunday.
     */
    @JvmName("vvalsrvijldmervn")
    public suspend fun preferredBackupPeriod(`value`: Output<String>) {
        this.preferredBackupPeriod = value
    }

    /**
     * @param value Data backup time. Format: HH:mmZ-HH:mmZ(UTC time).
     */
    @JvmName("rxqnoyrwqlpshtyr")
    public suspend fun preferredBackupTime(`value`: Output<String>) {
        this.preferredBackupTime = value
    }

    /**
     * @param value Recovery point frequency. Value Description:
     * - **1**: Hourly.
     * - **2**: Every two hours.
     * - **4**: Every four hours.
     * - **8**: Every eight hours.
     */
    @JvmName("nclybqtkastsggct")
    public suspend fun recoveryPointPeriod(`value`: Output<String>) {
        this.recoveryPointPeriod = value
    }

    /**
     * @param value Data backup retention days.
     */
    @JvmName("yvjrtymgnidvngeg")
    public suspend fun backupRetentionPeriod(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.backupRetentionPeriod = mapped
    }

    /**
     * @param value The instance ID.
     * > **NOTE:**  You can call the DescribeDBInstances operation to view the details of all AnalyticDB PostgreSQL instances in the target region, including the instance ID.
     */
    @JvmName("suviagvwxfwfaidb")
    public suspend fun dbInstanceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dbInstanceId = mapped
    }

    /**
     * @param value Whether to enable automatic recovery points. Value Description:
     * - **true**: enabled.
     * - **false**: Closed.
     */
    @JvmName("feekdttnmccmlgty")
    public suspend fun enableRecoveryPoint(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableRecoveryPoint = mapped
    }

    /**
     * @param value Data backup cycle. Separate multiple values with commas (,). Value Description:
     * - **Monday**: Monday.
     * - **Tuesday**: Tuesday.
     * - **Wednesday**: Wednesday.
     * - **Thursday**: Thursday.
     * - **Friday**: Friday.
     * - **Saturday**: Saturday.
     * - **Sunday**: Sunday.
     */
    @JvmName("xevkbjqkoldcufrj")
    public suspend fun preferredBackupPeriod(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.preferredBackupPeriod = mapped
    }

    /**
     * @param value Data backup time. Format: HH:mmZ-HH:mmZ(UTC time).
     */
    @JvmName("lfvwogilrmhddibg")
    public suspend fun preferredBackupTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.preferredBackupTime = mapped
    }

    /**
     * @param value Recovery point frequency. Value Description:
     * - **1**: Hourly.
     * - **2**: Every two hours.
     * - **4**: Every four hours.
     * - **8**: Every eight hours.
     */
    @JvmName("byiubbwssgcsnsbf")
    public suspend fun recoveryPointPeriod(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.recoveryPointPeriod = mapped
    }

    internal fun build(): BackupPolicyArgs = BackupPolicyArgs(
        backupRetentionPeriod = backupRetentionPeriod,
        dbInstanceId = dbInstanceId,
        enableRecoveryPoint = enableRecoveryPoint,
        preferredBackupPeriod = preferredBackupPeriod,
        preferredBackupTime = preferredBackupTime,
        recoveryPointPeriod = recoveryPointPeriod,
    )
}
