@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.gpdb.kotlin

import com.pulumi.alicloud.gpdb.kotlin.outputs.DbInstancePlanPlanConfig
import com.pulumi.alicloud.gpdb.kotlin.outputs.DbInstancePlanPlanConfig.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [DbInstancePlan].
 */
@PulumiTagMarker
public class DbInstancePlanResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DbInstancePlanArgs = DbInstancePlanArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DbInstancePlanArgsBuilder.() -> Unit) {
        val builder = DbInstancePlanArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): DbInstancePlan {
        val builtJavaResource = com.pulumi.alicloud.gpdb.DbInstancePlan(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return DbInstancePlan(builtJavaResource)
    }
}

/**
 * Provides a AnalyticDB for PostgreSQL (GPDB) DB Instance Plan resource.
 * For information about AnalyticDB for PostgreSQL (GPDB) DB Instance Plan and how to use it, see [What is DB Instance Plan](https://www.alibabacloud.com/help/en/analyticdb-for-postgresql/developer-reference/api-gpdb-2016-05-03-createdbinstanceplan).
 * > **NOTE:** Available since v1.189.0.
 * ## Import
 * GPDB DB Instance Plan can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:gpdb/dbInstancePlan:DbInstancePlan example <db_instance_id>:<plan_id>
 * ```
 */
public class DbInstancePlan internal constructor(
    override val javaResource: com.pulumi.alicloud.gpdb.DbInstancePlan,
) : KotlinCustomResource(javaResource, DbInstancePlanMapper) {
    /**
     * The ID of the GPDB instance.
     */
    public val dbInstanceId: Output<String>
        get() = javaResource.dbInstanceId().applyValue({ args0 -> args0 })

    /**
     * The name of the Plan.
     */
    public val dbInstancePlanName: Output<String>
        get() = javaResource.dbInstancePlanName().applyValue({ args0 -> args0 })

    /**
     * The execution information of the plan. See `plan_config` below.
     */
    public val planConfigs: Output<List<DbInstancePlanPlanConfig>>
        get() = javaResource.planConfigs().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    toKotlin(args0)
                })
            })
        })

    /**
     * The description of the Plan.
     */
    public val planDesc: Output<String>?
        get() = javaResource.planDesc().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The end time of the Plan.
     */
    public val planEndDate: Output<String>?
        get() = javaResource.planEndDate().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ID of the plan.
     */
    public val planId: Output<String>
        get() = javaResource.planId().applyValue({ args0 -> args0 })

    /**
     * The execution mode of the plan. Valid values: `Postpone`, `Regular`.
     */
    public val planScheduleType: Output<String>
        get() = javaResource.planScheduleType().applyValue({ args0 -> args0 })

    /**
     * The start time of the Plan.
     */
    public val planStartDate: Output<String>
        get() = javaResource.planStartDate().applyValue({ args0 -> args0 })

    /**
     * The type of the Plan. Valid values: `PauseResume`, `Resize`.
     */
    public val planType: Output<String>
        get() = javaResource.planType().applyValue({ args0 -> args0 })

    /**
     * The Status of the Plan. Valid values: `active`, `cancel`.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })
}

public object DbInstancePlanMapper : ResourceMapper<DbInstancePlan> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.gpdb.DbInstancePlan::class == javaResource::class

    override fun map(javaResource: Resource): DbInstancePlan = DbInstancePlan(
        javaResource as
            com.pulumi.alicloud.gpdb.DbInstancePlan,
    )
}

/**
 * @see [DbInstancePlan].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [DbInstancePlan].
 */
public suspend fun dbInstancePlan(
    name: String,
    block: suspend DbInstancePlanResourceBuilder.() -> Unit,
): DbInstancePlan {
    val builder = DbInstancePlanResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [DbInstancePlan].
 * @param name The _unique_ name of the resulting resource.
 */
public fun dbInstancePlan(name: String): DbInstancePlan {
    val builder = DbInstancePlanResourceBuilder()
    builder.name(name)
    return builder.build()
}
